/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.v1_0;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCheck;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCheckResult;
import com.verisign.epp.codec.fee.v1_0.EPPFeeChkData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCommand;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCommandData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCreData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCreate;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCredit;
import com.verisign.epp.codec.fee.v1_0.EPPFeeDelData;
import com.verisign.epp.codec.fee.v1_0.EPPFeePeriod;
import com.verisign.epp.codec.fee.v1_0.EPPFeeRenData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeRenew;
import com.verisign.epp.codec.fee.v1_0.EPPFeeTransfer;
import com.verisign.epp.codec.fee.v1_0.EPPFeeTrnData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeUpdData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeUpdate;
import com.verisign.epp.codec.fee.v1_0.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.serverstub.FeeSubDomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class FeeV1_0DomainHandler
implements FeeSubDomainHandler {
    private static Logger cat = Logger.getLogger((String)FeeV1_0DomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    public void doDomainCheck(EPPDomainCheckCmd aCheckCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainCheck: fee check extension = " + (EPPFeeCheck)aCheckCommand.getExtension(EPPFeeCheck.class)));
        EPPFeeChkData theChkDataExt = new EPPFeeChkData();
        EPPFeeCheck theFeeExt = (EPPFeeCheck)aCheckCommand.getExtension(EPPFeeCheck.class);
        Iterator domains = aCheckCommand.getNames().iterator();
        if (theFeeExt.hasCurrency()) {
            theChkDataExt.setCurrency(theFeeExt.getCurrency());
        } else {
            theChkDataExt.setCurrency("USD");
        }
        while (domains.hasNext()) {
            String domain = (String)domains.next();
            EPPFeeCheckResult theFeeResult = new EPPFeeCheckResult();
            theFeeResult.setObjID(domain);
            if (domain.equalsIgnoreCase("example.com") || domain.equalsIgnoreCase("example.net")) {
                theFeeResult.setAvailable(true);
            } else {
                if (domain.equalsIgnoreCase("example.xyz")) {
                    theFeeResult.setAvailable(false);
                    theFeeResult.setReason("Only 1 year registration periods are valid.");
                    continue;
                }
                theFeeResult.setAvailable(true);
            }
            if (domain.equalsIgnoreCase("premium.example")) {
                theFeeResult.setClassification("premium");
            } else {
                theFeeResult.setClassification("standard");
            }
            for (EPPFeeCommand command : theFeeExt.getCommands()) {
                EPPFeeCommandData theFeeCommandData = new EPPFeeCommandData(command);
                switch (command.getCommand()) {
                    case CREATE: {
                        if (domain.equalsIgnoreCase("premium.example")) {
                            theFeeCommandData.addFee(new EPPFeeValue(new BigDecimal("100.00"), "Registration Fee", true, "P5D", null));
                            theFeeCommandData.setStandard(false);
                            break;
                        }
                        theFeeCommandData.addFee(new EPPFeeValue(new BigDecimal("10.00"), "Registration Fee", true, "P5D", null));
                        theFeeCommandData.setStandard(true);
                        break;
                    }
                    case DELETE: {
                        break;
                    }
                    case RENEW: {
                        theFeeCommandData.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Renewal Fee", true, "P5D", null));
                        theFeeCommandData.setStandard(true);
                        break;
                    }
                    case UPDATE: {
                        break;
                    }
                    case TRANSFER: {
                        theFeeCommandData.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Transfer Fee", true, "P5D", null));
                        theFeeCommandData.setStandard(true);
                        break;
                    }
                    case RESTORE: {
                        theFeeCommandData.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Redemption Fee", false, null, null));
                        theFeeCommandData.setStandard(true);
                        break;
                    }
                    case CUSTOM: {
                        theFeeCommandData.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Redemption Fee", false, null, null));
                        theFeeCommandData.setStandard(true);
                    }
                }
                theFeeResult.addCommand(theFeeCommandData);
            }
            theChkDataExt.addCheckResult(theFeeResult);
        }
        aResponse.addExtension(theChkDataExt);
    }

    @Override
    public void doDomainInfo(EPPDomainInfoCmd aInfoCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)"doDomainInfo: do nothing for info command");
    }

    @Override
    public void doDomainCreate(EPPDomainCreateCmd aCreateCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainCreate: fee create extension = " + (EPPFeeCreate)aCreateCommand.getExtension(EPPFeeCreate.class)));
        EPPFeeCreData theCreData = new EPPFeeCreData();
        EPPFeeCreate theFeeExt = (EPPFeeCreate)aCreateCommand.getExtension(EPPFeeCreate.class);
        theCreData.setFees(theFeeExt.getFees());
        theCreData.setCurrency("USD");
        theCreData.setBalance(new BigDecimal("-5.00"));
        theCreData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theCreData);
    }

    @Override
    public void doDomainDelete(EPPDomainDeleteCmd aDeleteCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainDelete: fee delete extension to be added for " + aDeleteCommand.getName()));
        EPPFeeDelData theRespExt = new EPPFeeDelData("USD", new EPPFeeCredit(new BigDecimal("-5.00"), "AGP Credit"));
        theRespExt.setBalance(new BigDecimal("1005.00"));
        aResponse.addExtension(theRespExt);
    }

    @Override
    public void doDomainRenew(EPPDomainRenewCmd aRenewCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainRenew: fee renew extension = " + (EPPFeeRenew)aRenewCommand.getExtension(EPPFeeRenew.class)));
        EPPFeeRenData theRenData = new EPPFeeRenData();
        EPPFeeRenew theFeeExt = (EPPFeeRenew)aRenewCommand.getExtension(EPPFeeRenew.class);
        theRenData.setFees(theFeeExt.getFees());
        theRenData.setCurrency("USD");
        theRenData.setBalance(new BigDecimal("-5.00"));
        theRenData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theRenData);
    }

    @Override
    public void doDomainUpdate(EPPDomainUpdateCmd aUpdateCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainUpdate: fee update extension = " + (EPPFeeUpdate)aUpdateCommand.getExtension(EPPFeeUpdate.class)));
        EPPFeeUpdData theUpdData = new EPPFeeUpdData();
        EPPFeeUpdate theFeeExt = (EPPFeeUpdate)aUpdateCommand.getExtension(EPPFeeUpdate.class);
        theUpdData.setFees(theFeeExt.getFees());
        theUpdData.setCurrency("USD");
        theUpdData.setBalance(new BigDecimal("-5.00"));
        theUpdData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theUpdData);
    }

    @Override
    public void doDomainTransfer(EPPDomainTransferCmd aTransferCommand, EPPResponse aResponse, Object aData) {
        if (aTransferCommand.getOp().equals("query")) {
            EPPFeeTrnData theTrnData = new EPPFeeTrnData("USD", new EPPFeeValue(new BigDecimal("5.00")));
            theTrnData.setPeriod(new EPPFeePeriod(1));
            aResponse.addExtension(theTrnData);
        } else if (aTransferCommand.getOp().equals("request")) {
            if (aTransferCommand.hasExtension(EPPFeeTransfer.class)) {
                cat.info((Object)("doDomainTransfer: fee transfer request extension = " + (EPPFeeTransfer)aTransferCommand.getExtension(EPPFeeTransfer.class)));
                EPPFeeTransfer theFeeExt = (EPPFeeTransfer)aTransferCommand.getExtension(EPPFeeTransfer.class);
                EPPFeeTrnData theTrnData = new EPPFeeTrnData();
                theTrnData.setFees(theFeeExt.getFees());
                theTrnData.setCurrency("USD");
                aResponse.addExtension(theTrnData);
            } else {
                cat.info((Object)"doDomainTransfer: fee transfer request = null");
                System.out.println("doDomainTransfer: fee transfer request = null");
            }
        }
    }
}

