/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.registry.v02;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.registry.v02.EPPRegistryBatchJob;
import com.verisign.epp.codec.registry.v02.EPPRegistryBatchSchedule;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.v02.EPPRegistryContact;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactAddress;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactName;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactOrg;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactStreet;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.v02.EPPRegistryDS;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomain;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.v02.EPPRegistryExceedMaxExDate;
import com.verisign.epp.codec.registry.v02.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.v02.EPPRegistryHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryIDN;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryKey;
import com.verisign.epp.codec.registry.v02.EPPRegistryLanguage;
import com.verisign.epp.codec.registry.v02.EPPRegistryMaxSig;
import com.verisign.epp.codec.registry.v02.EPPRegistryMinMaxLength;
import com.verisign.epp.codec.registry.v02.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryPostal;
import com.verisign.epp.codec.registry.v02.EPPRegistryRGP;
import com.verisign.epp.codec.registry.v02.EPPRegistryRedemptionPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v02.EPPRegistryReservedNames;
import com.verisign.epp.codec.registry.v02.EPPRegistryServices;
import com.verisign.epp.codec.registry.v02.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.v02.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.v02.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryZone;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneSummary;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.registry.v02.EPPRegistry;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPRegistryTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPRegistryTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPRegistry registry = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new SecureRandom();

    public EPPRegistryTst(String name) {
        super(name);
    }

    public void testRegistry() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            try {
                numIterations = Integer.parseInt(iterationsStr);
                numIterations = numIterations < 1 ? 1 : numIterations;
            }
            catch (Exception e) {
                numIterations = 1;
            }
        }
        this.printStart("Test Suite");
        this.registryCreate("com", true);
        this.registryCreate("EXAMPLE1", true);
        this.registryCreate("EXAMPLE1", false);
        this.registryCreate("EXAMPLE2", true);
        this.registryCreate("EXAMPLE3", true);
        this.registryUpdate("EXAMPLE1", true);
        this.registryUpdate("EXAMPLE2", true);
        this.registryUpdate("EXAMPLE3", true);
        this.registryUpdate("EXAMPLE4", false);
        HashMap<String, Boolean> zonesAvail = new HashMap<String, Boolean>();
        zonesAvail.put("EXAMPLE1", Boolean.FALSE);
        zonesAvail.put("EXAMPLE2", Boolean.FALSE);
        zonesAvail.put("EXAMPLE3", Boolean.FALSE);
        zonesAvail.put("EXAMPLE4", Boolean.TRUE);
        this.registryCheck(zonesAvail);
        this.registryInfo(EPPRegistryInfoCmd.Mode.all, null, EPPRegistryInfoCmd.Scope.both);
        this.registryInfo(EPPRegistryInfoCmd.Mode.name, "EXAMPLE2", null);
        this.registryInfo(EPPRegistryInfoCmd.Mode.name, "com", null);
        this.registryInfo(EPPRegistryInfoCmd.Mode.system, null, null);
        this.registryDelete("EXAMPLE1", true);
        this.registryDelete("EXAMPLE1", false);
        this.registryDelete("EXAMPLE10", false);
        this.printEnd("Test Suite");
    }

    public void registryCheck(Map aZoneNames) {
        this.printStart("registryCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.print("registryCheck:");
            this.registry.setTransId("ABC-12345-XYZ");
            Iterator it = aZoneNames.entrySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next().getKey();
                System.out.print(" " + name + " ");
                this.registry.addZone(name);
            }
            System.out.println("");
            EPPRegistryCheckResp response = this.registry.sendCheck();
            System.out.println("registryCheck: Response = [" + response + "]\n\n");
            block3: for (Map.Entry entry : aZoneNames.entrySet()) {
                String name = (String)entry.getKey();
                Boolean available = (Boolean)entry.getValue();
                for (EPPRegistryCheckResult element : response.getCheckResults()) {
                    EPPRegistryCheckResult result = element;
                    if (!result.getName().equals(name)) continue;
                    if (result.isAvailable().booleanValue() == available.booleanValue()) continue block3;
                    EPPRegistryTst.fail((String)("Expected availability for tld \"" + name + "\": " + available + ", but got: " + result.isAvailable()));
                }
            }
            EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("registryCheck");
    }

    public void registryCreate(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryCreate");
            EPPRegistryCreateResp response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryCreate: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.setZone(EPPRegistryTst.buildZoneInfo(new EPPRegistryZoneName(aZoneName), true, true, true));
                response = this.registry.sendCreate();
                System.out.println("registryCreate: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryCreate");
    }

    public void registryDelete(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryDelete");
            EPPResponse response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryDelete: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.addZone(aZoneName);
                response = this.registry.sendDelete();
                System.out.println("registryDelete: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryDelete");
    }

    public void registryUpdate(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryUpdate");
            EPPResponse response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryUpdate: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.setZone(EPPRegistryTst.buildZoneInfo(new EPPRegistryZoneName(aZoneName), true, true, true));
                response = this.registry.sendUpdate();
                System.out.println("registryUpdate: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryUpdate");
    }

    public void registryInfo(EPPRegistryInfoCmd.Mode aMode, String aZoneName, EPPRegistryInfoCmd.Scope aScope) {
        this.printStart("registryInfo");
        EPPRegistryInfoResp response = null;
        try {
            switch (aMode) {
                case name: {
                    if (aZoneName == null) {
                        Assert.fail((String)"aZoneName must not be null with the name info mode");
                    }
                    this.registry.setTransId("ABC-12345-XYZ");
                    this.registry.addZone(aZoneName);
                    response = this.registry.sendInfo();
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                    EPPRegistryTst.assertTrue((response.getZoneList() == null && response.getZoneInfo() != null ? 1 : 0) != 0);
                    System.out.println("Zone accessible = " + response.getZoneInfo().isAccessible());
                    EPPRegistryZone info = response.getZoneInfo().getZone();
                    System.out.println("Zone name: " + info.getName());
                    if (info.getServices() != null) {
                        System.out.println("Services:");
                        Iterator<EPPRegistryServices.EPPRegistryObjURI> iterator = info.getServices().getObjURIs().iterator();
                        while (iterator.hasNext()) {
                            EPPRegistryServices.EPPRegistryObjURI element;
                            EPPRegistryServices.EPPRegistryObjURI objUri = element = iterator.next();
                            System.out.println("\tobjURI: " + objUri.getUri() + ", required: " + objUri.getRequired());
                        }
                    }
                    if (info.getServices() != null && info.getServices().getExtension() != null) {
                        System.out.println("Services extension:");
                        for (Object extUri : info.getServices().getExtension().getExtURIs()) {
                            System.out.println("\textURI: " + ((EPPRegistryServices.EPPRegistryURI)extUri).getUri() + ", required: " + ((EPPRegistryServices.EPPRegistryURI)extUri).getRequired());
                        }
                    }
                    System.out.println("crId: " + info.getCreatedBy());
                    System.out.println("crDate: " + info.getCreatedDate());
                    System.out.println("upId: " + info.getLastUpdatedBy());
                    System.out.println("upDate: " + info.getLastUpdatedDate());
                    if (info.hasBatchJobs()) {
                        List<EPPRegistryBatchJob> jobs = info.getBatchJobs();
                        for (EPPRegistryBatchJob currJob : jobs) {
                            System.out.println("batchJob: " + currJob);
                        }
                    }
                    info.getBatchJobs();
                    EPPRegistryDomain domain = info.getDomain();
                    EPPRegistryTst.assertTrue((domain != null ? 1 : 0) != 0);
                    System.out.println("Domain: " + domain);
                    EPPRegistryHost host = info.getHost();
                    EPPRegistryTst.assertTrue((host != null ? 1 : 0) != 0);
                    EPPRegistryContact contact = info.getContact();
                    EPPRegistryTst.assertTrue((contact != null ? 1 : 0) != 0);
                    break;
                }
                case all: {
                    if (aScope == null) {
                        Assert.fail((String)"aScope must not be null with the all info mode");
                    }
                    this.registry.setTransId("ABC-12345-XYZ");
                    this.registry.setAllScope(EPPRegistryInfoCmd.Scope.both);
                    response = this.registry.sendInfo();
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                    EPPRegistryTst.assertTrue((response.getZoneList() != null && response.getZoneList().getZoneList() != null && response.getZoneInfo() == null && response.getZoneList().getZoneList().size() > 0 ? 1 : 0) != 0);
                    System.out.println("All TLDs: ");
                    for (EPPRegistryZoneSummary tld : response.getZoneList().getZoneList()) {
                        EPPRegistryTst.assertTrue((tld.getName().getName() != null && tld.getName().getName().length() > 0 ? 1 : 0) != 0);
                        EPPRegistryTst.assertTrue((tld.getCreateDate() != null ? 1 : 0) != 0);
                        System.out.print(tld.getName() + "\tcreated on " + tld.getCreateDate());
                        if (tld.getUpdateDate() != null) {
                            System.out.println("\tupdated on " + tld.getUpdateDate());
                            continue;
                        }
                        System.out.println();
                    }
                    break;
                }
                case system: {
                    this.registry.setTransId("ABC-12345-XYZ");
                    this.registry.setInfoMode(aMode);
                    response = this.registry.sendInfo();
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                    System.out.println("System Info Response = " + response);
                }
            }
            this.printEnd("registryInfo");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }

    public String makeZoneName() {
        int len = this.rd.nextInt(15);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(97 + this.rd.nextInt(26));
        }
        return sb.toString();
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPRegistryTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.registry = new EPPRegistry(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    public static EPPRegistryZone buildZoneInfo(EPPRegistryZoneName aZone, boolean aContactPolicy, boolean aDsDataInterface, boolean aHostObjModel) {
        EPPRegistryZone theZoneInfo = new EPPRegistryZone(aZone);
        theZoneInfo.setDomain(EPPRegistryTst.buildDomain(aDsDataInterface, aHostObjModel));
        theZoneInfo.setHost(EPPRegistryTst.buildHost(aHostObjModel));
        if (aContactPolicy) {
            theZoneInfo.setContact(EPPRegistryTst.buildContact());
        }
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:registry-1.2", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:registry-1.1", Boolean.FALSE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:registry-1.2", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:registry-1.1", Boolean.FALSE));
        theZoneInfo.setServices(services);
        theZoneInfo.setCreatedBy("crId");
        theZoneInfo.setCreatedDate(new Date());
        theZoneInfo.setUnsupportedData(EPPRegistryZone.UnsupportedData.fail);
        EPPRegistryBatchJob batchJob = new EPPRegistryBatchJob("localTzBatch", "Batch with multiple local time schedules (name and offset)");
        batchJob.addSchedule(new EPPRegistryBatchSchedule("04:00:00", "EST5EDT"));
        batchJob.addSchedule(new EPPRegistryBatchSchedule("07:00:00-05:00", null));
        theZoneInfo.addBatchJob(batchJob);
        batchJob = new EPPRegistryBatchJob("multiBatchSchedule", "Batch with multiple UTC schedules");
        batchJob.addSchedule(new EPPRegistryBatchSchedule("12:00:00Z", null));
        batchJob.addSchedule(new EPPRegistryBatchSchedule("12:00:00Z", EPPRegistryBatchSchedule.DayOfWeek.SUNDAY, null));
        batchJob.addSchedule(new EPPRegistryBatchSchedule("17:00:00Z", 15, null));
        theZoneInfo.addBatchJob(batchJob);
        return theZoneInfo;
    }

    public static EPPRegistryDomain buildDomain() {
        return EPPRegistryTst.buildDomain(true, true);
    }

    public static EPPRegistryDomain buildDomain(boolean aDsDataInterface, boolean aHostObjModel) {
        EPPRegistryDomain domain = new EPPRegistryDomain();
        ArrayList<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
        EPPRegistryDomainName domainName = new EPPRegistryDomainName();
        domainName.setLevel(2);
        domainName.setMinLength(5);
        domainName.setMaxLength(50);
        domainName.setAlphaNumStart(true);
        domainName.setAlphaNumEnd(false);
        domainName.setALabelSupported(true);
        domainName.setNameRegex(new EPPRegistryRegex("^[a-zA-Z\\d][a-zA-Z\\d\\-]{4,49}$", "5 to 50 DNS characters starting with alphanumeric"));
        EPPRegistryReservedNames reservedNames = new EPPRegistryReservedNames();
        ArrayList<String> rNames = new ArrayList<String>();
        reservedNames.setReservedNames(rNames);
        rNames.add("reserved1");
        rNames.add("reserved2");
        domainName.setReservedNames(reservedNames);
        domainNames.add(domainName);
        try {
            domainName = (EPPRegistryDomainName)domainName.clone();
            domainName.setLevel(3);
            domainName.getReservedNames().setReservedNames(new ArrayList<String>());
            domainName.getReservedNames().setReservedNameURI("http://testrn.vrsn.com");
            domainNames.add(domainName);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        domain.setDomainNames(domainNames);
        EPPRegistryIDN idn = new EPPRegistryIDN();
        idn.setIdnVersion("1.1");
        idn.setIdnaVersion("2008");
        idn.setUnicodeVersion("6.0");
        idn.addLanguage(new EPPRegistryLanguage("CHI", "http://www.iana.org/domains/idn-tables/tables/com_zh_1.1.txt", EPPRegistryLanguage.VariantStrategy.restricted));
        idn.addLanguage(new EPPRegistryLanguage("LATN", "http://www.iana.org/domains/idn-tables/tables/eu_latn_1.0.html", EPPRegistryLanguage.VariantStrategy.blocked));
        idn.setCommingleAllowed(Boolean.TRUE);
        domain.setIdn(idn);
        domain.setPremiumSupport(true);
        domain.setContactsSupported(false);
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.admin, 1, 4));
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.billing, 2, 5));
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.tech, 3, 6));
        domain.setNameServerLimit(new EPPRegistryDomainNSLimit(1, 16));
        if (aHostObjModel) {
            domain.setChildHostLimit(new EPPRegistryDomainHostLimit((Integer)0, null));
        }
        domain.addPeriod(new EPPRegistryDomainPeriod("create", Boolean.TRUE));
        domain.addPeriod(new EPPRegistryDomainPeriod("renew", 1, EPPRegistryPeriodType.Unit.y, 10, EPPRegistryPeriodType.Unit.y, 2, EPPRegistryPeriodType.Unit.y));
        domain.addPeriod(new EPPRegistryDomainPeriod("transfer", 1, EPPRegistryPeriodType.Unit.y, 8, EPPRegistryPeriodType.Unit.y, 3, EPPRegistryPeriodType.Unit.y));
        domain.addExceedMaxExDate(new EPPRegistryExceedMaxExDate(EPPRegistryExceedMaxExDate.Policy.fail, "renew"));
        domain.addExceedMaxExDate(new EPPRegistryExceedMaxExDate(EPPRegistryExceedMaxExDate.Policy.clip, "transfer"));
        domain.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(1, EPPRegistryPeriodType.Unit.y));
        domain.addGracePeriod(new EPPRegistryGracePeriod("create", 1, EPPRegistryPeriodType.Unit.m));
        domain.addGracePeriod(new EPPRegistryGracePeriod("renew", 2, EPPRegistryPeriodType.Unit.h));
        domain.addGracePeriod(new EPPRegistryGracePeriod("transfer", 3, EPPRegistryPeriodType.Unit.d));
        EPPRegistryRGP rgp = new EPPRegistryRGP();
        rgp.setPendingDeletePeriod(new EPPRegistryPendingDeletePeriodType(1, EPPRegistryPeriodType.Unit.m));
        rgp.setRedemptionPeriod(new EPPRegistryRedemptionPeriodType(1, EPPRegistryPeriodType.Unit.m));
        rgp.setPendingRestorePeriod(new EPPRegistryPendingRestorePeriodType(1, EPPRegistryPeriodType.Unit.m));
        domain.setRgp(rgp);
        EPPRegistryDNSSEC dnssec = new EPPRegistryDNSSEC();
        if (aDsDataInterface) {
            EPPRegistryDS ds = new EPPRegistryDS((Integer)0, (Integer)13);
            ds.addAlgorithm(3);
            ds.addDigestType(1);
            dnssec.setDs(ds);
        } else {
            EPPRegistryKey key = new EPPRegistryKey((Integer)0, (Integer)13);
            key.addFlags(257);
            key.addProtocol(3);
            key.addAlgorithm(3);
            dnssec.setKey(key);
        }
        dnssec.setMaxSigLife(new EPPRegistryMaxSig(true, 1, 2, 3));
        dnssec.setUrgent(Boolean.TRUE);
        domain.setDnssec(dnssec);
        domain.setMaxCheckDomain(12);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientHold");
        supportedStatus.addStatus("serverHold");
        supportedStatus.addStatus("clientRenewProhibited");
        supportedStatus.addStatus("serverRenewProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("inactive");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingRenew");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        domain.setSupportedStatus(supportedStatus);
        domain.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        domain.setNullAuthInfoSupported(Boolean.FALSE);
        if (aHostObjModel) {
            domain.setHostModelSupported(EPPRegistryDomain.HostModelSupported.hostObj);
        } else {
            domain.setHostModelSupported(EPPRegistryDomain.HostModelSupported.hostAttr);
        }
        return domain;
    }

    public static EPPRegistryContact buildContact() {
        EPPRegistryContact contact = new EPPRegistryContact();
        contact.setContactIdRegex(new EPPRegistryRegex("^.*$"));
        contact.setContactIdPrefix("EX");
        contact.setSharePolicy(EPPRegistryContact.SharePolicy.perZone);
        contact.setIntPostalInfoTypeSupport(EPPRegistryContact.PostalInfoTypeSupport.locOrIntSupport);
        contact.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        contact.setMaxCheckContact(15);
        EPPRegistryPostal postalInfo = new EPPRegistryPostal();
        postalInfo.setLocCharRegex(new EPPRegistryRegex("^.*$"));
        postalInfo.setName(new EPPRegistryContactName(5, 15));
        postalInfo.setOrg(new EPPRegistryContactOrg(2, 12));
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setEmailRegex(new EPPRegistryRegex("^.+\\..+$"));
        EPPRegistryContactAddress address = new EPPRegistryContactAddress();
        address.setStreet(new EPPRegistryContactStreet(2, 12, 0, 3));
        address.setCity(new EPPRegistryContactCity(5, 15));
        address.setStateProvince(new EPPRegistryContactStateProvince(1, 11));
        address.setPostalCode(new EPPRegistryContactPostalCode(2, 12));
        postalInfo.setAddress(address);
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setVoiceExt(new EPPRegistryMinMaxLength(5, 15));
        postalInfo.setFaxExt(new EPPRegistryMinMaxLength(5, 15));
        contact.setMaxCheckContact(5);
        contact.setPostalInfo(postalInfo);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        contact.setSupportedStatus(supportedStatus);
        return contact;
    }

    public static EPPRegistryHost buildHost(boolean aHostObjModel) {
        EPPRegistryHost host = new EPPRegistryHost();
        if (aHostObjModel) {
            host.setInternal(new EPPRegistryInternalHost(5, 15, EPPRegistryInternalHost.SharePolicy.perZone, Boolean.FALSE));
            host.setExternal(new EPPRegistryExternalHost(2, 12, EPPRegistryExternalHost.SharePolicy.perZone, Boolean.FALSE));
            host.setMaxCheckHost(15);
            EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
            supportedStatus.addStatus("clientDeleteProhibited");
            supportedStatus.addStatus("serverDeleteProhibited");
            supportedStatus.addStatus("clientUpdateProhibited");
            supportedStatus.addStatus("serverUpdateProhibited");
            supportedStatus.addStatus("linked");
            supportedStatus.addStatus("ok");
            supportedStatus.addStatus("pendingCreate");
            supportedStatus.addStatus("pendingDelete");
            supportedStatus.addStatus("pendingTransfer");
            supportedStatus.addStatus("pendingUpdate");
            host.setSupportedStatus(supportedStatus);
        } else {
            host.setInternal(new EPPRegistryInternalHost(5, 15, null, Boolean.FALSE));
            host.setExternal(new EPPRegistryExternalHost(2, 12, null, Boolean.FALSE));
        }
        host.setNameRegex(new EPPRegistryRegex("^.*$"));
        host.addInvalidIP("http://www.example.com/invalidip-1.txt");
        host.addInvalidIP("http://www.example.com/invalidip-2.txt");
        return host;
    }
}

