/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryUpdateCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryZone;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EPPRegistry {
    private EPPSession session = null;
    private String transId = null;
    private EPPRegistryInfoCmd.Mode infoMode = null;
    private EPPRegistryInfoCmd.Scope infoScope = null;
    private List<EPPRegistryZoneName> zoneList = null;
    private EPPRegistryZone zone = null;
    private Vector<EPPCodecComponent> extensions = null;

    public EPPRegistry(EPPSession aSession) {
        this.session = aSession;
    }

    public EPPRegistryCheckResp sendCheck() throws EPPCommandException {
        if (this.zoneList == null || this.zoneList.isEmpty()) {
            throw new EPPCommandException("At least one zone name is required for sendCheck()");
        }
        EPPRegistryCheckCmd theCommand = new EPPRegistryCheckCmd(this.transId, this.zoneList);
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return (EPPRegistryCheckResp)this.session.processDocument(theCommand, EPPRegistryCheckResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.zoneList == null || this.zoneList.size() != 1) {
            throw new EPPCommandException("One zone name is required for sendDelete()");
        }
        EPPRegistryDeleteCmd theCommand = new EPPRegistryDeleteCmd(this.transId, this.zoneList.get(0));
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPRegistryInfoResp sendInfo() throws EPPCommandException {
        EPPCommand theCommand = null;
        if (this.infoMode == null) {
            throw new EPPCommandException("The info mode is not set.");
        }
        switch (this.infoMode) {
            case name: {
                if (this.zoneList.size() != 1) {
                    throw new EPPCommandException("One zone name is required for sendInfo()");
                }
                theCommand = new EPPRegistryInfoCmd(this.transId, this.zoneList.get(0));
                break;
            }
            case all: {
                theCommand = new EPPRegistryInfoCmd(this.transId, this.infoScope);
                break;
            }
            case system: {
                theCommand = new EPPRegistryInfoCmd(this.transId, EPPRegistryInfoCmd.Mode.system);
            }
        }
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return (EPPRegistryInfoResp)this.session.processDocument(theCommand, EPPRegistryInfoResp.class);
    }

    public EPPRegistryCreateResp sendCreate() throws EPPCommandException {
        if (this.zone == null) {
            throw new EPPCommandException("Zone information is required for sendCreate()");
        }
        EPPRegistryCreateCmd theCommand = new EPPRegistryCreateCmd(this.transId, this.zone);
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return (EPPRegistryCreateResp)this.session.processDocument(theCommand, EPPRegistryCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.zone == null) {
            throw new EPPCommandException("Zone information is required for sendUpdate()");
        }
        EPPRegistryUpdateCmd theCommand = new EPPRegistryUpdateCmd(this.transId, this.zone);
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPSession getSession() {
        return this.session;
    }

    public void setSession(EPPSession aSession) {
        this.session = aSession;
    }

    public String getTransId() {
        return this.transId;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public List<EPPRegistryZoneName> getZoneList() {
        return this.zoneList;
    }

    public void setZoneList(List<EPPRegistryZoneName> aZoneList) {
        if (aZoneList == null) {
            this.zoneList = new ArrayList<EPPRegistryZoneName>();
        } else {
            this.zoneList = aZoneList;
            this.infoMode = EPPRegistryInfoCmd.Mode.name;
        }
    }

    public void addZone(String aZone) {
        if (this.zoneList == null) {
            this.zoneList = new ArrayList<EPPRegistryZoneName>();
        }
        this.zoneList.add(new EPPRegistryZoneName(aZone, EPPRegistryZoneName.Form.aLabel));
        this.infoMode = EPPRegistryInfoCmd.Mode.name;
    }

    public void addZone(EPPRegistryZoneName aZone) {
        if (this.zoneList == null) {
            this.zoneList = new ArrayList<EPPRegistryZoneName>();
        }
        this.zoneList.add(aZone);
        this.infoMode = EPPRegistryInfoCmd.Mode.name;
    }

    public EPPRegistryInfoCmd.Scope getAllScope() {
        return this.infoScope;
    }

    public void setAllScope(EPPRegistryInfoCmd.Scope aScope) {
        this.infoScope = aScope;
        this.infoMode = EPPRegistryInfoCmd.Mode.all;
    }

    public boolean hasInfoMode() {
        return this.infoMode != null;
    }

    public EPPRegistryInfoCmd.Mode getInfoMode() {
        return this.infoMode;
    }

    public void setInfoMode(EPPRegistryInfoCmd.Mode aInfoMode) {
        this.infoMode = aInfoMode;
    }

    public void setZone(EPPRegistryZone aZone) {
        this.zone = aZone;
    }

    public Vector<EPPCodecComponent> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Vector<EPPCodecComponent> aExtensions) {
        this.extensions = aExtensions;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }

    private void resetRegistry() {
        this.transId = null;
        this.zoneList = new ArrayList<EPPRegistryZoneName>();
        this.infoMode = null;
        this.infoScope = null;
        this.extensions = null;
        this.zone = null;
    }
}

