/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCheckResp;
import com.verisign.epp.codec.contact.EPPContactCreateResp;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.jobscontact.EPPJobsContactCreateCmd;
import com.verisign.epp.codec.jobscontact.EPPJobsContactInfoResp;
import com.verisign.epp.codec.jobscontact.EPPJobsContactUpdateCmd;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPContact;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPJobsContactTst
extends TestCase {
    private EPPContact contact = null;
    private EPPSession session = null;
    private int iteration = 0;
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private Random rd = new Random(System.currentTimeMillis());
    private static final Logger cat = Logger.getLogger((String)EPPJobsContactTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPJobsContactTst(String name) {
        super(name);
    }

    public void testJobsContact() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.jobsContactCreate();
            this.jobsContactInfo();
            this.jobsContactUpdate();
            this.jobsContactCheck();
            this.jobsContactDelete();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void jobsContactInfo() {
        this.printStart("jobsContactInfo");
        try {
            System.out.println("JobsContact: Contact Info");
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId("jobsContactInfo");
            EPPContactInfoResp contactResponse = this.contact.sendInfo();
            System.out.println("JobsContact: Response = [" + contactResponse + "]\n\n");
            if (contactResponse.hasExtension(EPPJobsContactInfoResp.class)) {
                EPPJobsContactInfoResp ext = (EPPJobsContactInfoResp)contactResponse.getExtension(EPPJobsContactInfoResp.class);
                System.out.println("jobsContact: Title = " + ext.getTitle());
                System.out.println("jobsContact: Website = " + ext.getWebsite());
                System.out.println("jobsContact: industryType = " + ext.getIndustryType());
                System.out.println("jobsContact: isAdminContact = " + ext.isAdminContact());
                System.out.println("jobsContact: isAssociationMember = " + ext.isAssociationMember());
            } else {
                Assert.fail((String)"JobsContact: EPPJobsContact extension NOT found");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("jobsContactInfo");
    }

    public void jobsContactCreate() {
        this.printStart("jobsContactCreate");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("jobsContactCreate: Contact create for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId(theName);
            this.contact.setVoicePhone("+1.7035555555");
            this.contact.setVoiceExt("123");
            this.contact.setFaxNumber("+1.7035555556");
            this.contact.setFaxExt("456");
            this.contact.setEmail("jdoe@example.com");
            Vector<String> streets = new Vector<String>();
            streets.addElement("123 Example Dr.");
            streets.addElement("Suite 100");
            streets.addElement("This is third line");
            EPPContactAddress address = new EPPContactAddress();
            address.setStreets(streets);
            address.setCity("Dulles");
            address.setStateProvince("VA");
            address.setPostalCode("20166-6503");
            address.setCountry("US");
            EPPContactPostalDefinition name = new EPPContactPostalDefinition("loc");
            name.setName("John Doe");
            name.setOrg("Example Inc.");
            name.setAddress(address);
            this.contact.addPostalInfo(name);
            EPPContactAddress Intaddress = new EPPContactAddress();
            Intaddress.setStreets(streets);
            Intaddress.setCity("Dulles");
            Intaddress.setStateProvince("VA");
            Intaddress.setPostalCode("20166-6503");
            Intaddress.setCountry("US");
            EPPContactPostalDefinition Intname = new EPPContactPostalDefinition("int");
            Intname.setName("John Doe");
            Intname.setOrg("Example Inc.");
            Intname.setAddress(Intaddress);
            this.contact.addPostalInfo(Intname);
            EPPContactDisclose disclose = new EPPContactDisclose();
            disclose.setFlag(false);
            disclose.setNameInt(true);
            disclose.setNameLoc(true);
            disclose.setOrgInt(true);
            disclose.setOrgLoc(true);
            disclose.setAddrInt(true);
            disclose.setAddrLoc(true);
            disclose.setVoice(false);
            disclose.setFax(false);
            disclose.setEmail(false);
            this.contact.setDisclose(disclose);
            EPPJobsContactCreateCmd createExt = new EPPJobsContactCreateCmd("SE", "www.verisign.com", "IT", "Yes", "No");
            this.contact.addExtension(createExt);
            EPPContactCreateResp response = (EPPContactCreateResp)this.contact.sendCreate();
            System.out.println("contactCreate: Response = [" + response + "]\n\n");
            System.out.println("Contact ID : " + response.getId());
            System.out.println("Contact Creation Date : " + response.getCreationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("jobsContactCreate");
    }

    public void jobsContactUpdate() {
        this.printStart("jobsContactUpdate");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\njobsContactUpdate: Contact update for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            Vector<String> streets = new Vector<String>();
            streets.addElement("123 Example Dr.");
            streets.addElement("Suite 100");
            streets.addElement("This is third line");
            EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
            EPPContactPostalDefinition postal = new EPPContactPostalDefinition("Joe Brown", "Example Corp.", "loc", address);
            this.contact.addStatus("pendingDelete");
            this.contact.addPostalInfo(postal);
            this.contact.setVoicePhone("+1.7035555555");
            this.contact.setVoiceExt("456");
            this.contact.setFaxNumber("+1.7035555555");
            this.contact.setFaxExt("789");
            this.contact.setAuthorizationId("ClientXYZ");
            EPPContactDisclose disclose = new EPPContactDisclose();
            disclose.setFlag(false);
            disclose.setNameInt(true);
            disclose.setNameLoc(true);
            disclose.setOrgInt(true);
            disclose.setOrgLoc(true);
            disclose.setAddrInt(true);
            disclose.setAddrLoc(true);
            disclose.setVoice(false);
            disclose.setFax(false);
            disclose.setEmail(false);
            this.contact.setDisclose(disclose);
            EPPJobsContactUpdateCmd updateExt = new EPPJobsContactUpdateCmd();
            updateExt.setTitle("Customer Service");
            updateExt.setWebsite("www.verisign.com");
            updateExt.setIndustry("IT");
            updateExt.setAdminContact("No");
            updateExt.setAssociationMember("No");
            this.contact.addExtension(updateExt);
            EPPResponse response = this.contact.sendUpdate();
            System.out.println("jobsContactUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("jobsContactUpdate");
    }

    public void jobsContactCheck() {
        this.printStart("jobsContactCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(this.makeContactName());
            this.contact.addContactId(this.makeContactName());
            this.contact.addContactId(this.makeContactName());
            EPPContactCheckResp response = this.contact.sendCheck();
            System.out.println("jobsContactCheck: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("jobsContactCheck");
    }

    public void jobsContactDelete() {
        this.printStart("jobsContactDelete");
        try {
            System.out.println("\n----------------------------------------------------------------");
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(this.makeContactName());
            EPPResponse response = this.contact.sendDelete();
            System.out.println("jobsContactDelete: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("jobsContactDelete");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse contactResponse = this.session.getResponse();
            if (contactResponse != null && !contactResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + contactResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.contact = new EPPContact(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPJobsContactTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse domainResponse = this.session.getResponse();
        aException.printStackTrace();
        if (domainResponse != null && !domainResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + domainResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPJobsContactTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPJobsContactTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }
}

