/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.codestudio.util.GenericPool;
import com.codestudio.util.GenericPoolManager;
import com.codestudio.util.GenericPoolMetaData;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PoolMetaData;
import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class EPPApplication {
    private static boolean _parserInitialized = false;

    public void initialize(String myConfigFile) throws EPPCommandException {
        EPPEnvSingle env = EPPEnvSingle.getInstance();
        try {
            env.initialize(myConfigFile);
        }
        catch (EPPEnvException e) {
            throw new EPPCommandException("EPPEnvException is thrown :" + e.getMessage());
        }
        try {
            switch (EPPEnv.getLogMode()) {
                case 0: {
                    Logger root = Logger.getRootLogger();
                    root.setLevel(EPPEnv.getLogLevel());
                    root.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), EPPEnv.getLogFile(), true));
                    break;
                }
                case 1: {
                    Long logCfgFileWatch;
                    boolean theLoadedFromClassPath;
                    String theLogCfgFileProp = EPPEnv.getLogCfgFile();
                    File theLogCfgFile = new File(theLogCfgFileProp);
                    URL theLogCfgFileURL = null;
                    if (theLogCfgFile.exists()) {
                        theLoadedFromClassPath = false;
                        theLogCfgFileURL = new URL("file:" + theLogCfgFileProp);
                        System.out.println("EPPApplication: Loading log configuration file <" + theLogCfgFileProp + "> from file system");
                    } else {
                        theLoadedFromClassPath = true;
                        theLogCfgFileURL = ClassLoader.getSystemResource(theLogCfgFileProp);
                        if (theLogCfgFileURL == null) {
                            theLogCfgFileURL = EPPApplication.class.getClassLoader().getResource(theLogCfgFileProp);
                            System.out.println("EPPApplication: Loading log configuration file <" + theLogCfgFileProp + "> from EPPApplication ClassLoader");
                        } else {
                            System.out.println("EPPApplication: Loading log configuration file <" + theLogCfgFileProp + "> from system ClassLoader");
                        }
                    }
                    if (theLogCfgFileURL == null) {
                        throw new EPPCommandException("EPPApplication: Unable to find configuration file :" + theLogCfgFileProp);
                    }
                    DOMConfigurator.configure((URL)theLogCfgFileURL);
                    if (!theLoadedFromClassPath && (logCfgFileWatch = EPPEnv.getLogCfgFileWatch()) != null) {
                        DOMConfigurator.configureAndWatch((String)theLogCfgFileProp, (long)logCfgFileWatch);
                        System.out.println("EPPApplication: Added watch of log configuration file <" + theLogCfgFileProp + "> every " + logCfgFileWatch + " ms");
                    }
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new EPPCommandException("Invalid log mode of :" + EPPEnv.getLogMode());
                }
            }
        }
        catch (EPPEnvException e) {
            throw new EPPCommandException("EPPApplication.initialze():  When initializing Log " + e);
        }
        catch (IOException e) {
            throw new EPPCommandException("EPPApplication.initialze():  When initializing Log " + e);
        }
        try {
            Vector protocolExts = null;
            Vector commandExts = null;
            try {
                protocolExts = EPPEnv.getProtocolExtensions();
            }
            catch (EPPEnvException ex) {
                protocolExts = null;
            }
            try {
                commandExts = EPPEnv.getCmdResponseExtensions();
            }
            catch (EPPEnvException ex) {
                commandExts = null;
            }
            Vector<String> extensionsVector = new Vector<String>();
            if (protocolExts != null && protocolExts.elements().hasMoreElements()) {
                for (int i = 0; i < protocolExts.size(); ++i) {
                    extensionsVector.addElement((String)protocolExts.elementAt(i));
                }
            }
            if (commandExts != null && commandExts.elements().hasMoreElements()) {
                for (int j = 0; j < commandExts.size(); ++j) {
                    extensionsVector.addElement((String)commandExts.elementAt(j));
                }
            }
            EPPCodec.getInstance().init(EPPEnv.getMapFactories(), extensionsVector);
        }
        catch (EPPEnvException e) {
            throw new EPPCommandException("EPPApplication.initialze():  when initializing EPPCodec: " + e);
        }
        catch (EPPCodecException e) {
            throw new EPPCommandException("EPPApplication.initialze():  when initializing EPPCodec: " + e);
        }
        this.initParserPool();
    }

    private void initParserPool() {
        if (!_parserInitialized) {
            GenericPoolMetaData parserMeta = new GenericPoolMetaData();
            parserMeta.setName("EPP_XML_PARSER_POOL");
            parserMeta.setObjectType("com.verisign.epp.util.EPPSchemaCachingParser");
            parserMeta.setInitialObjects(EPPEnv.getClientParserInitObjs());
            parserMeta.setMinimumSize(EPPEnv.getClientParserMinSize());
            parserMeta.setMaximumSize(EPPEnv.getClientParserMaxSize());
            parserMeta.setMaximumSoft(EPPEnv.getClientParserMaxSoft());
            parserMeta.setObjectTimeout(EPPEnv.getClientParserObjTimeout());
            parserMeta.setUserTimeout(EPPEnv.getClientParserUserTimeout());
            parserMeta.setSkimmerFrequency(EPPEnv.getClientParserSkimmerFreq());
            parserMeta.setShrinkBy(EPPEnv.getClientParserShrinkBy());
            parserMeta.setLogFile(EPPEnv.getClientParserLogFile());
            parserMeta.setDebugging(EPPEnv.getClientParserDebug());
            GenericPool parserPool = new GenericPool((PoolMetaData)parserMeta);
            GenericPoolManager.getInstance().addPool("EPP_XML_PARSER_POOL", (ObjectPool)parserPool);
            GenericPoolMetaData transformerMeta = new GenericPoolMetaData();
            transformerMeta.setName("EPP_XML_TRANSFORMER_POOL");
            transformerMeta.setObjectType("com.verisign.epp.util.EPPTransformer");
            transformerMeta.setInitialObjects(EPPEnv.getClientParserInitObjs());
            transformerMeta.setMinimumSize(EPPEnv.getClientParserMinSize());
            transformerMeta.setMaximumSize(EPPEnv.getClientParserMaxSize());
            transformerMeta.setMaximumSoft(EPPEnv.getClientParserMaxSoft());
            transformerMeta.setObjectTimeout(EPPEnv.getClientParserObjTimeout());
            transformerMeta.setUserTimeout(EPPEnv.getClientParserUserTimeout());
            transformerMeta.setSkimmerFrequency(EPPEnv.getClientParserSkimmerFreq());
            transformerMeta.setShrinkBy(EPPEnv.getClientParserShrinkBy());
            transformerMeta.setLogFile(EPPEnv.getClientParserLogFile());
            transformerMeta.setDebugging(EPPEnv.getClientParserDebug());
            GenericPool transformerPool = new GenericPool((PoolMetaData)transformerMeta);
            GenericPoolManager.getInstance().addPool("EPP_XML_TRANSFORMER_POOL", (ObjectPool)transformerPool);
            _parserInitialized = true;
        }
    }

    public void endApplication() throws EPPCommandException {
    }
}

