/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.codestudio.util.GenericPool;
import com.codestudio.util.GenericPoolManager;
import com.codestudio.util.GenericPoolMetaData;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PoolMetaData;
import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPComponentNotFoundException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPAssembler;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;

public class EPPXMLAssembler
implements EPPAssembler {
    private static Logger cat = Logger.getLogger((String)EPPXMLAssembler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static boolean _parserInitialized = false;
    private EPPCodec codec = EPPCodec.getInstance();
    private EPPSendReceiveLogger sendReceiveLogger;

    public EPPXMLAssembler() {
        this.initParserPool();
        this.sendReceiveLogger = EPPEnv.getSendReceiveLogger();
    }

    @Override
    public void toStream(EPPEventResponse aResponse, OutputStream aOutputStream, Object aData) throws EPPAssemblerException {
        cat.debug((Object)"toStream(EPPEventResponse, OutputStream): Enter");
        try {
            EPPMessage response = aResponse.getResponse();
            Document domDocument = this.codec.encode(response);
            EPPXMLStream xmlStream = new EPPXMLStream("EPP_XML_PARSER_POOL", "EPP_XML_TRANSFORMER_POOL");
            xmlStream.write(domDocument, aOutputStream, response);
        }
        catch (EPPEncodeException e) {
            cat.error((Object)"toStream(EPPEventResponse, OutputStream)", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.MISSINGPARAMETER);
        }
        catch (EPPException e) {
            cat.error((Object)"toStream(EPPEventResponse, OutputStream)", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.FATAL);
        }
        cat.debug((Object)"toStream(EPPEventResponse, OutputStream): Return");
    }

    @Override
    public EPPEvent toEvent(InputStream aStream, Object aData) throws EPPAssemblerException {
        cat.debug((Object)"toEvent(InputStream): Enter");
        EPPMessage message = null;
        try {
            EPPXMLStream xmlStream = new EPPXMLStream("EPP_XML_PARSER_POOL", "EPP_XML_TRANSFORMER_POOL");
            byte[] thePacket = xmlStream.readPacket(aStream);
            Document domDocument = xmlStream.decodePacket(thePacket);
            message = this.codec.decode(domDocument);
            this.sendReceiveLogger.logReceive(thePacket, message);
            if (aData != null && aData instanceof SessionData) {
                SessionData sessionData = (SessionData)aData;
                sessionData.setAttribute("PACKET", thePacket);
            }
        }
        catch (EPPComponentNotFoundException e) {
            cat.error((Object)"toEvent(InputStream):", (Throwable)e);
            switch (e.getKind()) {
                case 1: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.COMMANDNOTFOUND);
                }
                case 3: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.EXTENSIONNOTFOUND);
                }
                case 2: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.RESPONSENOTFOUND);
                }
            }
        }
        catch (EPPDecodeException e) {
            cat.error((Object)"toEvent(InputStream):", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.MISSINGPARAMETER);
        }
        catch (EPPAssemblerException e) {
            cat.error((Object)"toEvent(InputStream):", (Throwable)e);
            throw e;
        }
        catch (EPPException e) {
            cat.error((Object)"toEvent(InputStream):", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.XML);
        }
        catch (InterruptedIOException e) {
            cat.debug((Object)"toEvent(InputStream):", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.INTRUPTEDIO);
        }
        catch (IOException e) {
            cat.error((Object)"toEvent(InputStream):", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.CLOSECON);
        }
        cat.debug((Object)"toEvent(InputStream): Return");
        return new EPPEvent(message);
    }

    private void initParserPool() {
        if (!_parserInitialized) {
            GenericPoolMetaData parserMeta = new GenericPoolMetaData();
            parserMeta.setName("EPP_XML_PARSER_POOL");
            parserMeta.setObjectType("com.verisign.epp.util.EPPSchemaCachingParser");
            parserMeta.setInitialObjects(EPPEnv.getServerParserInitObjs());
            parserMeta.setMinimumSize(EPPEnv.getServerParserMinSize());
            parserMeta.setMaximumSize(EPPEnv.getServerParserMaxSize());
            parserMeta.setMaximumSoft(EPPEnv.getServerParserMaxSoft());
            parserMeta.setObjectTimeout(EPPEnv.getServerParserObjTimeout());
            parserMeta.setUserTimeout(EPPEnv.getServerParserUserTimeout());
            parserMeta.setSkimmerFrequency(EPPEnv.getServerParserSkimmerFreq());
            parserMeta.setShrinkBy(EPPEnv.getServerParserShrinkBy());
            parserMeta.setLogFile(EPPEnv.getServerParserLogFile());
            parserMeta.setDebugging(EPPEnv.getServerParserDebug());
            GenericPool parserPool = new GenericPool((PoolMetaData)parserMeta);
            GenericPoolManager.getInstance().addPool("EPP_XML_PARSER_POOL", (ObjectPool)parserPool);
            GenericPoolMetaData transformerMeta = new GenericPoolMetaData();
            transformerMeta.setName("EPP_XML_TRANSFORMER_POOL");
            transformerMeta.setObjectType("com.verisign.epp.util.EPPTransformer");
            transformerMeta.setInitialObjects(EPPEnv.getServerParserInitObjs());
            transformerMeta.setMinimumSize(EPPEnv.getServerParserMinSize());
            transformerMeta.setMaximumSize(EPPEnv.getServerParserMaxSize());
            transformerMeta.setMaximumSoft(EPPEnv.getServerParserMaxSoft());
            transformerMeta.setObjectTimeout(EPPEnv.getServerParserObjTimeout());
            transformerMeta.setUserTimeout(EPPEnv.getServerParserUserTimeout());
            transformerMeta.setSkimmerFrequency(EPPEnv.getServerParserSkimmerFreq());
            transformerMeta.setShrinkBy(EPPEnv.getServerParserShrinkBy());
            transformerMeta.setLogFile(EPPEnv.getServerParserLogFile());
            transformerMeta.setDebugging(EPPEnv.getServerParserDebug());
            GenericPool transformerPool = new GenericPool((PoolMetaData)transformerMeta);
            GenericPoolManager.getInstance().addPool("EPP_XML_TRANSFORMER_POOL", (ObjectPool)transformerPool);
            _parserInitialized = true;
        }
    }
}

