/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPHello;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPLogoutCmd;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPGenHandler
implements EPPEventHandler {
    private static final String NS = "urn:ietf:params:xml:ns:epp-1.0";
    private static Logger cat = Logger.getLogger((String)EPPGenHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    public final String getNamespace() {
        return NS;
    }

    @Override
    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        EPPEventResponse response;
        cat.debug((Object)"handleEvent(EPPEvent, Object): Enter");
        try {
            cat.debug((Object)"handleEvent(EPPEvent, Object): Call preHandleEvent");
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            cat.info((Object)("handleEvent(EPPEvent, Object): Exception with preHandleEvent: " + e));
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (message instanceof EPPLoginCmd) {
            cat.debug((Object)"handleEvent(EPPEvent, Object): Handle EPPLoginCmd");
            response = this.doLogin(aEvent, aData);
        } else if (message instanceof EPPLogoutCmd) {
            cat.debug((Object)"handleEvent(EPPEvent, Object): Handle EPPLogoutCmd");
            response = this.doLogout(aEvent, aData);
        } else if (message instanceof EPPPollCmd) {
            cat.debug((Object)"handleEvent(EPPEvent, Object): Handle EPPPollCmd");
            response = this.doPoll(aEvent, aData);
        } else if (message instanceof EPPHello) {
            cat.debug((Object)"handleEvent(EPPEvent, Object): Handle EPPHello");
            response = this.doHello(aEvent, aData);
        } else {
            cat.info((Object)("handleEvent(EPPEvent, Object): Event " + message.getClass().getName() + " not supported"));
            throw new EPPEventException("In EPPGenHandler an event was sent that is not supported");
        }
        try {
            cat.debug((Object)"handleEvent(EPPEvent, Object): Call postHandleEvent");
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            cat.info((Object)("handleEvent(EPPEvent, Object): Exception with postHandleEvent: " + e));
            return new EPPEventResponse(e.getResponse());
        }
        cat.debug((Object)"handleEvent(EPPEvent, Object): Exit");
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doLogin(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doLogout(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doPoll(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doHello(EPPEvent var1, Object var2);
}

