/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.whois;

import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.whois.EPPWhoisInf;
import com.verisign.epp.codec.whois.EPPWhoisInfData;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPWhoisTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPWhoisTst(String name) {
        super(name);
    }

    public void testWhoisInf() {
        EPPCodecTst.printStart("testWhoisInf");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd("ABC-12345", "whois-true.com");
        theCommand.setHosts("all");
        theCommand.addExtension(new EPPWhoisInf(true));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainInfoCmd("ABC-67890", "whois-false.com");
        theCommand.setHosts("del");
        theCommand.addExtension(new EPPWhoisInf(false));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testWhoisInf");
    }

    public void testWhoisInfData() {
        EPPCodecTst.printStart("testWhoisInfData");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPTransId respTransId = new EPPTransId("ABC-67890", "12345-XYZ");
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        theResponse.addExtension(new EPPWhoisInfData("Example Registrar Inc.", "whois.example.com", "http://www.example.com"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        theResponse.addExtension(new EPPWhoisInfData("Example Registrar Inc.", "whois.example.com", "http://www.example.com", "iris.example.com"));
        commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testWhoisInfData");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPWhoisTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.whois.EPPWhoisExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPWhoisExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPWhoisTst Thread " + i, EPPWhoisTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPWhoisTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

