/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckCmd;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckResp;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPValidateMapFactory
extends EPPMapFactory {
    public static final String NS = "urn:ietf:params:xml:ns:validate-0.2";
    public static final String NS_CONTACT = "urn:ietf:params:xml:ns:contact-1.0";
    public static final String NS_PREFIX = "validate";
    public static final String NS_PREFIX_CONTACT = "contact";
    private EPPService service = new EPPService("validate", "urn:ietf:params:xml:ns:validate-0.2", null);

    public EPPValidateMapFactory() {
        this.service.setServiceType(0);
    }

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("validate:check"))) {
            return new EPPValidateCheckCmd();
        }
        throw new EPPCodecException("Invalid command element " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("validate:chkData"))) {
            return new EPPValidateCheckResp();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set getXmlSchemas() {
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        theSchemas.add("contact-1.0.xsd");
        theSchemas.add("validate-0.2.xsd");
        return theSchemas;
    }
}

