/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryReservedNames
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryReservedNames.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "reservedNames";
    public static final String ELM_NAME = "registry:reservedNames";
    static final String ELM_RESERVED_NAME = "reservedName";
    static final String ELM_RESERVED_NAME_URI = "reservedNameURI";
    private List<String> reservedNames = new ArrayList<String>();
    private String reservedNameURI = null;

    public EPPRegistryReservedNames() {
    }

    public EPPRegistryReservedNames(List<String> aReservedNames) {
        this.setReservedNames(aReservedNames);
    }

    public EPPRegistryReservedNames(String aReservedNameURI) {
        this.reservedNameURI = aReservedNameURI;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryReservedNames.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.reservedNames, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:reservedName");
        EPPUtil.encodeString(aDocument, root, this.reservedNameURI, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:reservedNameURI");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.reservedNames = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_RESERVED_NAME);
        this.reservedNameURI = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_RESERVED_NAME_URI);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryReservedNames)) {
            return false;
        }
        EPPRegistryReservedNames theComp = (EPPRegistryReservedNames)aObject;
        if (!(this.reservedNames != null ? EPPUtil.equalLists(this.reservedNames, theComp.reservedNames) : theComp.reservedNames == null)) {
            cat.error((Object)"EPPRegistryReservedNames.equals(): reservedNames not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reservedNameURI, theComp.reservedNameURI)) {
            cat.error((Object)"EPPRegistryReservedNames.equals(): reservedNameURI not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.reservedNames != null && this.reservedNames.size() > 0 && this.reservedNameURI != null && this.reservedNameURI.trim().length() > 0) {
            throw new EPPCodecException("reservedNames and reservedNameURI cannot be used together");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryReservedNames clone = (EPPRegistryReservedNames)super.clone();
        if (this.reservedNames != null) {
            clone.reservedNames = (List)((ArrayList)this.reservedNames).clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasReservedNames() {
        return this.reservedNames != null && !this.reservedNames.isEmpty();
    }

    public List<String> getReservedNames() {
        return this.reservedNames;
    }

    public void setReservedNames(List<String> aReservedNames) {
        this.reservedNames = aReservedNames == null ? new ArrayList<String>() : aReservedNames;
    }

    public void addReservedName(String aReservedName) {
        if (this.reservedNames == null) {
            this.reservedNames = new ArrayList<String>();
        }
        this.reservedNames.add(aReservedName);
    }

    public boolean hasReservedNameURI() {
        return this.reservedNameURI != null;
    }

    public String getReservedNameURI() {
        return this.reservedNameURI;
    }

    public void setReservedNameURI(String aReservedNameURI) {
        this.reservedNameURI = aReservedNameURI;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

