/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPRegistrySystemInfo
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "system";
    public static final String ELM_NAME = "registry:system";
    private static final String ELM_MAX_CONNECTIONS = "maxConnections";
    private static final String ELM_IDLE_TIMEOUT = "idleTimeout";
    private static final String ELM_ABSOLUTE_TIMEOUT = "absoluteTimeout";
    private static final String ELM_COMMAND_TIMEOUT = "commandTimeout";
    private static final String ELM_TRANS_LIMIT = "transLimit";
    private static final String ATTR_PER_MS = "perMs";
    private static Logger cat = Logger.getLogger((String)EPPRegistrySystemInfo.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private Integer maxConnections = null;
    private Integer idleTimeout = null;
    private Integer absoluteTimeout = null;
    private Integer commandTimeout = null;
    private Integer transLimit = null;
    private Integer perMs = null;

    public EPPRegistrySystemInfo() {
    }

    public EPPRegistrySystemInfo(Integer aMaxConnections, Integer aIdleTimeout, Integer aAbsoluteTimeout, Integer aCommandTimeout, Integer aTransLimit, Integer aPerMs) {
        this.maxConnections = aMaxConnections;
        this.idleTimeout = aIdleTimeout;
        this.absoluteTimeout = aAbsoluteTimeout;
        this.commandTimeout = aCommandTimeout;
        this.transLimit = aTransLimit;
        this.perMs = aPerMs;
    }

    public boolean hasMaxConnections() {
        return this.maxConnections != null;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer aMaxConnections) {
        this.maxConnections = aMaxConnections;
    }

    public boolean hasIdleTimeout() {
        return this.idleTimeout != null;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer aIdleTimeout) {
        this.idleTimeout = aIdleTimeout;
    }

    public boolean hasAbsoluteTimeout() {
        return this.absoluteTimeout != null;
    }

    public Integer getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public void setAbsoluteTimeout(Integer aAbsoluteTimeout) {
        this.absoluteTimeout = aAbsoluteTimeout;
    }

    public boolean hasCommandTimeout() {
        return this.commandTimeout != null;
    }

    public Integer getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setCommandTimeout(Integer aCommandTimeout) {
        this.commandTimeout = aCommandTimeout;
    }

    public boolean hasTransLimit() {
        return this.transLimit != null;
    }

    public Integer getTransLimit() {
        return this.transLimit;
    }

    public void setTransLimit(Integer aTransLimit) {
        this.transLimit = aTransLimit;
    }

    public void setTransLimit(Integer aTransLimit, Integer aPerMs) {
        this.transLimit = aTransLimit;
        this.perMs = aPerMs;
    }

    public boolean hasPerMs() {
        return this.perMs != null;
    }

    public Integer getPerMs() {
        return this.perMs;
    }

    public void setPerMs(Integer aPerMs) {
        this.perMs = aPerMs;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPRegistrySystemInfo.encode(Document)");
        }
        if (this.hasTransLimit() && !this.hasPerMs()) {
            throw new EPPEncodeException("Transaction limit is set without the per milliseconds attribute in EPPRegistrySystemInfo.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        EPPUtil.encodeInteger(aDocument, root, this.maxConnections, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:maxConnections");
        EPPUtil.encodeInteger(aDocument, root, this.idleTimeout, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:idleTimeout");
        EPPUtil.encodeInteger(aDocument, root, this.absoluteTimeout, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:absoluteTimeout");
        EPPUtil.encodeInteger(aDocument, root, this.commandTimeout, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:commandTimeout");
        if (this.hasTransLimit()) {
            Element theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:transLimit");
            theElm.setAttribute(ATTR_PER_MS, this.perMs.toString());
            Text transLimitText = aDocument.createTextNode(this.transLimit.toString());
            theElm.appendChild(transLimitText);
            root.appendChild(theElm);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.maxConnections = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_MAX_CONNECTIONS);
        this.idleTimeout = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_IDLE_TIMEOUT);
        this.absoluteTimeout = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_ABSOLUTE_TIMEOUT);
        this.commandTimeout = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_COMMAND_TIMEOUT);
        Element theTransLimitElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_TRANS_LIMIT);
        if (theTransLimitElm != null) {
            Node theTextNode = theTransLimitElm.getFirstChild();
            if (theTextNode != null) {
                this.transLimit = Integer.valueOf(theTextNode.getNodeValue());
                String thePerMs = theTransLimitElm.getAttribute(ATTR_PER_MS);
                this.perMs = thePerMs != null && !thePerMs.isEmpty() ? Integer.valueOf(thePerMs) : null;
            }
        } else {
            this.transLimit = null;
            this.perMs = null;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistrySystemInfo)) {
            return false;
        }
        EPPRegistrySystemInfo theComp = (EPPRegistrySystemInfo)aObject;
        if (!EqualityUtil.equals(this.maxConnections, theComp.maxConnections)) {
            cat.error((Object)"EPPRegistrySystemInfo.equals(): maxConnections not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.idleTimeout, theComp.idleTimeout)) {
            cat.error((Object)"EPPRegistrySystemInfo.equals(): idleTimeout not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.absoluteTimeout, this.absoluteTimeout)) {
            cat.error((Object)"EPPRegistrySystemInfo.equals(): absoluteTimeout not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.commandTimeout, theComp.commandTimeout)) {
            cat.error((Object)"EPPRegistrySystemInfo.equals(): commandTimeout not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.transLimit, theComp.transLimit)) {
            cat.error((Object)"EPPRegistrySystemInfo.equals(): transLimit not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.perMs, theComp.perMs)) {
            cat.error((Object)"EPPRegistrySystemInfo.equals(): perMs not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistrySystemInfo clone = (EPPRegistrySystemInfo)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }
}

