/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryMaxSig
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryMaxSig.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "maxSigLife";
    public static final String ELM_NAME = "registry:maxSigLife";
    public static final String ELM_CLIENT_DEFINED = "clientDefined";
    public static final String ELM_DEFAULT = "default";
    public static final String ELM_MIN = "min";
    public static final String ELM_MAX = "max";
    private Boolean clientDefined = Boolean.FALSE;
    private Integer defaultLife;
    private Integer min = null;
    private Integer max = null;

    public EPPRegistryMaxSig() {
    }

    public EPPRegistryMaxSig(Boolean aClientDefined, Integer aDefaultLife, Integer aMin, Integer aMax) {
        this.setClientDefined(aClientDefined);
        this.defaultLife = aDefaultLife;
        this.min = aMin;
        this.max = aMax;
    }

    public EPPRegistryMaxSig(boolean clientDefined, int defaultLife, int min, int max) {
        this((Boolean)clientDefined, (Integer)defaultLife, (Integer)min, (Integer)max);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryMaxSig.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        if (this.clientDefined == null) {
            this.clientDefined = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.clientDefined.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:clientDefined");
        if (this.defaultLife != null) {
            EPPUtil.encodeString(aDocument, root, this.defaultLife.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:default");
        }
        if (this.min != null) {
            EPPUtil.encodeString(aDocument, root, this.min.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:min");
        }
        if (this.max != null) {
            EPPUtil.encodeString(aDocument, root, this.max.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:max");
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.clientDefined = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_CLIENT_DEFINED);
        this.defaultLife = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_DEFAULT);
        this.min = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_MIN);
        this.max = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_MAX);
    }

    void validateState() throws EPPCodecException {
        if (!(this.clientDefined != null && this.clientDefined != Boolean.FALSE || this.min == null && this.max == null)) {
            throw new EPPCodecException("None of min or max should be set when clientDefined is set to false");
        }
        if (this.min != null && this.min < 1) {
            throw new EPPCodecException("min, if specified, should be no less than 1");
        }
        if (this.max != null && this.max < 1) {
            throw new EPPCodecException("max, if specified, should be no less than 1");
        }
        if (this.defaultLife != null && this.defaultLife < 1) {
            throw new EPPCodecException("defaultLife, if specified, should be no less than 1");
        }
        if (this.min != null && this.max != null && this.max < this.min) {
            throw new EPPCodecException("max should be no less than min");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryMaxSig)) {
            return false;
        }
        EPPRegistryMaxSig theComp = (EPPRegistryMaxSig)aObject;
        if (!EqualityUtil.equals(this.clientDefined, theComp.clientDefined)) {
            cat.error((Object)"EPPRegistryMaxSig.equals(): clientDefined not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.defaultLife, theComp.defaultLife)) {
            cat.error((Object)"EPPRegistryMaxSig.equals(): defaultLife not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.min, theComp.min)) {
            cat.error((Object)"EPPRegistryMaxSig.equals(): min not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.max, theComp.max)) {
            cat.error((Object)"EPPRegistryMaxSig.equals(): max not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Boolean getClientDefined() {
        return this.clientDefined;
    }

    public void setClientDefined(Boolean aClientDefined) {
        this.clientDefined = aClientDefined == null ? Boolean.FALSE : aClientDefined;
    }

    public boolean hasDefaultLife() {
        return this.defaultLife != null;
    }

    public Integer getDefaultLife() {
        return this.defaultLife;
    }

    public void setDefaultLife(Integer aDefaultLife) {
        this.defaultLife = aDefaultLife;
    }

    public boolean hasMin() {
        return this.min != null;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer aMin) {
        this.min = aMin;
    }

    public boolean hasMax() {
        return this.max != null;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer aMax) {
        this.max = aMax;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }
}

