/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryKey
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryKey.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "keyDataInterface";
    public static final String ELM_NAME = "registry:keyDataInterface";
    public static final String ELM_MIN = "min";
    public static final String ELM_MAX = "max";
    public static final String ELM_ALGORITHM = "alg";
    private Integer min = null;
    private Integer max = null;
    private List<String> algorithms = new ArrayList<String>();

    public EPPRegistryKey() {
    }

    public EPPRegistryKey(Integer aMin, Integer aMax, List<String> aAlgorithms) {
        this.min = aMin;
        this.max = aMax;
        this.algorithms = aAlgorithms;
    }

    public EPPRegistryKey(int aMin, int aMax, List<String> aAlgorithms) {
        this.min = aMin;
        this.max = aMax;
        this.algorithms = aAlgorithms;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryKey.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:" + this.getRootName());
        EPPUtil.encodeString(aDocument, root, this.min.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:min");
        EPPUtil.encodeString(aDocument, root, this.max.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:max");
        EPPUtil.encodeList(aDocument, root, this.algorithms, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:alg");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.min = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_MIN);
        this.max = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_MAX);
        this.algorithms = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_ALGORITHM);
    }

    void validateState() throws EPPCodecException {
        if (this.min == null || this.min < 0) {
            throw new EPPCodecException("min is required and should be greater than or equal to 0");
        }
        if (this.max == null || this.max < this.min) {
            throw new EPPCodecException("max is required and should be greater than or equal to min");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryKey clone = (EPPRegistryKey)super.clone();
        if (this.algorithms != null) {
            clone.algorithms = (List)((ArrayList)this.algorithms).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryKey)) {
            return false;
        }
        EPPRegistryKey theComp = (EPPRegistryKey)aObject;
        if (!EqualityUtil.equals(this.min, theComp.min)) {
            cat.error((Object)"EPPRegistryKey.equals(): min not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.max, theComp.max)) {
            cat.error((Object)"EPPRegistryKey.equals(): max not equal");
            return false;
        }
        if (!(this.algorithms != null ? EPPUtil.equalLists(this.algorithms, theComp.algorithms) : theComp.algorithms == null)) {
            cat.error((Object)"EPPRegistryKey.equals(): algorithms not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer aMin) {
        this.min = aMin;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer aMax) {
        this.max = aMax;
    }

    public boolean hasAlgorithms() {
        return this.algorithms != null && !this.algorithms.isEmpty();
    }

    public List<String> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(List<String> aAlgorithms) {
        this.algorithms = aAlgorithms == null ? new ArrayList<String>() : aAlgorithms;
    }

    public void addAlgorithm(String aAltorithm) {
        if (this.algorithms == null) {
            this.algorithms = new ArrayList<String>();
        }
        this.algorithms.add(aAltorithm);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }

    protected String getRootName() {
        return ELM_LOCALNAME;
    }
}

