/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryAbstractMinMax;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryInternalHost
extends EPPRegistryAbstractMinMax {
    private static Logger cat = Logger.getLogger((String)EPPRegistryInternalHost.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "internal";
    public static final String ELM_NAME = "registry:internal";
    protected static final String ELM_MIN_IP = "minIP";
    protected static final String ELM_MAX_IP = "maxIP";
    public static final String ELM_SHARE_POLICY = "sharePolicy";
    public static final String ELM_UNIQUE_IP_ADDRESSES_REQUIRED = "uniqueIpAddressesRequired";
    private SharePolicy sharePolicy = null;
    private Boolean uniqueIpAddressesRequired = Boolean.FALSE;

    public EPPRegistryInternalHost() {
    }

    public EPPRegistryInternalHost(Integer aMin, Integer aMax, SharePolicy aSharePolicy, Boolean aUniqueIpAddressesRequired) {
        super(aMin, aMax);
        this.setSharePolicy(aSharePolicy);
        this.setUniqueIpAddressesRequired(aUniqueIpAddressesRequired);
    }

    public EPPRegistryInternalHost(int aMin, int aMax, SharePolicy aSharePolicy, Boolean aUniqueIpAddressesRequired) {
        this((Integer)aMin, (Integer)aMax, aSharePolicy, aUniqueIpAddressesRequired);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        this.validateState();
        Element root = super.encode(aDocument);
        if (this.hasSharePolicy()) {
            EPPUtil.encodeString(aDocument, root, this.sharePolicy.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:sharePolicy");
        }
        EPPUtil.encodeString(aDocument, root, this.uniqueIpAddressesRequired.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:uniqueIpAddressesRequired");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        String theSharePolicyStr = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_SHARE_POLICY);
        this.sharePolicy = theSharePolicyStr == null ? null : SharePolicy.valueOf(theSharePolicyStr);
        this.setUniqueIpAddressesRequired(EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_UNIQUE_IP_ADDRESSES_REQUIRED));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryInternalHost)) {
            return false;
        }
        EPPRegistryInternalHost theComp = (EPPRegistryInternalHost)aObject;
        if (!EqualityUtil.equals((Object)this.sharePolicy, (Object)theComp.sharePolicy)) {
            this.getLogger().error((Object)"EPPRegistryInternalHost.equals(): sharePolicy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.uniqueIpAddressesRequired, theComp.uniqueIpAddressesRequired)) {
            this.getLogger().error((Object)"EPPRegistryInternalHost.equals(): uniqueIpAddressesRequired not equal");
            return false;
        }
        return true;
    }

    public boolean hasSharePolicy() {
        return this.sharePolicy != null;
    }

    public SharePolicy getSharePolicy() {
        return this.sharePolicy;
    }

    public void setSharePolicy(SharePolicy aSharePolicy) {
        this.sharePolicy = aSharePolicy;
    }

    public Boolean getUniqueIpAddressesRequired() {
        return this.uniqueIpAddressesRequired;
    }

    public void setUniqueIpAddressesRequired(Boolean aUniqueIpAddressesRequired) {
        this.uniqueIpAddressesRequired = aUniqueIpAddressesRequired == null ? Boolean.FALSE : aUniqueIpAddressesRequired;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected String getRootName() {
        return ELM_LOCALNAME;
    }

    @Override
    protected String getElmMin() {
        return ELM_MIN_IP;
    }

    @Override
    protected String getElmMax() {
        return ELM_MAX_IP;
    }

    @Override
    protected Logger getLogger() {
        return cat;
    }

    public static enum SharePolicy {
        perZone,
        perSystem;

    }
}

