/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneName;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryInfoCmd
extends EPPInfoCmd {
    private static Logger cat = Logger.getLogger(EPPRegistryInfoCmd.class);
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "registry:info";
    private static final String ELM_REGISTRY_ALL = "all";
    private static final String ELM_REGISTRY_SYSTEM = "system";
    private boolean all = false;
    private EPPRegistryZoneName name;
    private boolean system = false;

    public EPPRegistryInfoCmd() {
    }

    public EPPRegistryInfoCmd(String aTransId, String aName) {
        super(aTransId);
        this.setName(aName);
        this.all = false;
        this.system = false;
    }

    public EPPRegistryInfoCmd(String aTransId, EPPRegistryZoneName aName) {
        super(aTransId);
        this.setName(aName);
        this.all = false;
        this.system = false;
    }

    public EPPRegistryInfoCmd(String aTransId, boolean aAll) {
        super(aTransId);
        this.name = null;
        this.all = aAll;
        this.system = false;
    }

    public EPPRegistryInfoCmd(String aTransId, boolean aAll, boolean aSystem) {
        super(aTransId);
        this.name = null;
        this.all = aAll;
        this.system = aSystem;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.name == null && !this.all && !this.system) {
            throw new EPPEncodeException("At least one needs to be set (name, all, or system)");
        }
        if (this.name != null && (this.all || this.system)) {
            throw new EPPEncodeException("Name cannot be set with either all or system set");
        }
        if (this.all && this.system) {
            throw new EPPEncodeException("Both all and system cannot be set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        if (this.hasName()) {
            EPPUtil.encodeComp(aDocument, root, this.name);
        } else if (this.all) {
            root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:all"));
        } else {
            root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:system"));
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = (EPPRegistryZoneName)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "name", EPPRegistryZoneName.class);
        this.all = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_REGISTRY_ALL) != null;
        this.system = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_REGISTRY_SYSTEM) != null;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryInfoCmd)) {
            cat.error((Object)("EPPRegistryInfoCmd.equals(): " + aObject.getClass().getName() + " not EPPRegistryInfoCmd instance"));
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error((Object)"EPPRegistryInfoCmd.equals(): super class not equal");
            return false;
        }
        EPPRegistryInfoCmd theComp = (EPPRegistryInfoCmd)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error((Object)"EPPRegistryInfoCmd.equals(): name not equal");
            return false;
        }
        if (this.all != theComp.all) {
            cat.error((Object)"EPPRegistryInfoCmd.equals(): all not equal");
            return false;
        }
        if (this.system != theComp.system) {
            cat.error((Object)"EPPRegistryInfoCmd.equals(): system not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryInfoCmd clone = (EPPRegistryInfoCmd)super.clone();
        if (this.name != null) {
            clone.name = (EPPRegistryZoneName)this.name.clone();
        }
        return clone;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public EPPRegistryZoneName getName() {
        return this.name;
    }

    public void setName(EPPRegistryZoneName aName) {
        this.name = aName;
    }

    public void setName(String aName) {
        this.name = new EPPRegistryZoneName(aName, EPPRegistryZoneName.Form.aLabel);
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean aAll) {
        this.all = aAll;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean aSystem) {
        this.system = aSystem;
    }
}

