/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryLanguage;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryIDN
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryIDN.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "idn";
    public static final String ELM_NAME = "registry:idn";
    public static final String ELM_IDN_VERSION = "idnVersion";
    public static final String ELM_IDNA_VERSION = "idnaVersion";
    public static final String ELM_UNICODE_VERSION = "unicodeVersion";
    public static final String ELM_ENCODING = "encoding";
    public static final String ELM_COMMINGLE_ALLOWED = "commingleAllowed";
    private String idnVersion = null;
    private String idnaVersion = null;
    private String unicodeVersion = null;
    private Boolean commingleAllowed = Boolean.FALSE;
    private String encoding = "Punycode";
    private List<EPPRegistryLanguage> languages = new ArrayList<EPPRegistryLanguage>();

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryIDN.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        if (this.idnVersion != null && this.idnVersion.trim().length() > 0) {
            EPPUtil.encodeString(aDocument, root, this.idnVersion, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:idnVersion");
        }
        EPPUtil.encodeString(aDocument, root, this.idnaVersion, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:idnaVersion");
        EPPUtil.encodeString(aDocument, root, this.unicodeVersion, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:unicodeVersion");
        if (this.encoding == null && this.encoding.trim().length() == 0) {
            this.encoding = "Punycode";
        }
        EPPUtil.encodeString(aDocument, root, this.encoding, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:encoding");
        if (this.commingleAllowed == null) {
            this.commingleAllowed = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.commingleAllowed.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:commingleAllowed");
        if (this.languages != null && this.languages.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.languages);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.idnVersion = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_IDN_VERSION);
        this.idnaVersion = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_IDNA_VERSION);
        this.unicodeVersion = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_UNICODE_VERSION);
        this.encoding = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_ENCODING);
        if (this.encoding == null && this.encoding.trim().length() == 0) {
            this.encoding = "Punycode";
        }
        this.commingleAllowed = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_COMMINGLE_ALLOWED);
        if (this.commingleAllowed == null) {
            this.commingleAllowed = Boolean.FALSE;
        }
        this.languages = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:language", EPPRegistryLanguage.class);
    }

    void validateState() throws EPPCodecException {
        if (this.unicodeVersion == null || this.unicodeVersion.trim().length() == 0) {
            throw new EPPCodecException("unicodeVersion element is not set");
        }
        if (this.idnaVersion == null || this.idnaVersion.trim().length() == 0) {
            throw new EPPCodecException("idnaVersion element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryIDN clone = (EPPRegistryIDN)super.clone();
        if (this.languages != null) {
            clone.languages = (List)((ArrayList)this.languages).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryIDN)) {
            return false;
        }
        EPPRegistryIDN theComp = (EPPRegistryIDN)aObject;
        if (!EqualityUtil.equals(this.idnVersion, theComp.idnVersion)) {
            cat.error((Object)"EPPRegistryIDN.equals(): idnVersion not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.idnaVersion, theComp.idnaVersion)) {
            cat.error((Object)"EPPRegistryIDN.equals(): idnaVersion not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.unicodeVersion, theComp.unicodeVersion)) {
            cat.error((Object)"EPPRegistryIDN.equals(): unicodeVersion not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.encoding, theComp.encoding)) {
            cat.error((Object)"EPPRegistryIDN.equals(): encoding not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.commingleAllowed, theComp.commingleAllowed)) {
            cat.error((Object)"EPPRegistryIDN.equals(): commingleAllowed not equal");
            return false;
        }
        if (!(this.languages != null ? EPPUtil.equalLists(this.languages, theComp.languages) : theComp.languages == null)) {
            cat.error((Object)"EPPRegistryIDN.equals(): languages not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getIdnVersion() {
        return this.idnVersion;
    }

    public void setIdnVersion(String aIdnVersion) {
        this.idnVersion = aIdnVersion;
    }

    public String getUnicodeVersion() {
        return this.unicodeVersion;
    }

    public void setUnicodeVersion(String aUnicodeVersion) {
        this.unicodeVersion = aUnicodeVersion;
    }

    public String getIdnaVersion() {
        return this.idnaVersion;
    }

    public void setIdnaVersion(String aIdnaVersion) {
        this.idnaVersion = aIdnaVersion;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String aEncoding) {
        this.encoding = aEncoding;
    }

    public Boolean getCommingleAllowed() {
        return this.commingleAllowed;
    }

    public void setCommingleAllowed(Boolean aCommingleAllowed) {
        this.commingleAllowed = aCommingleAllowed;
    }

    public List<EPPRegistryLanguage> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<EPPRegistryLanguage> aLanguages) {
        this.languages = aLanguages;
    }

    public void addLanguage(EPPRegistryLanguage language) {
        if (this.languages == null) {
            this.languages = new ArrayList<EPPRegistryLanguage>();
        }
        this.languages.add(language);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }
}

