/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryCheckResult
implements EPPCodecComponent {
    private static final long serialVersionUID = -3349624534103691414L;
    private static Logger cat = Logger.getLogger(EPPRegistryCheckResult.class);
    static final String ELM_NAME = "registry:cd";
    private static final String ELM_REGISTRY_NAME = "registry:name";
    private static final String ELM_REGISTRY_REASON = "registry:reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LANG = "lang";
    private static final String VALUE_LANG = "en";
    private String language = "en";
    private String name;
    private Boolean available;
    private String reason;

    public EPPRegistryCheckResult() {
        this.name = null;
        this.available = Boolean.TRUE;
    }

    public EPPRegistryCheckResult(String name, Boolean available) {
        this.name = name;
        this.available = available;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required element is not set");
        }
        if (this.available == null) {
            throw new EPPEncodeException("available required attribute is not set");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        root.appendChild(nameElm);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_AVAIL, this.available);
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        if (this.reason != null) {
            Element reasonElm = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_REASON);
            root.appendChild(reasonElm);
            if (!this.language.equals(VALUE_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        this.name = theNameElm.getFirstChild().getNodeValue();
        this.available = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_AVAIL);
        Element theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_REASON);
        if (theReasonElm != null) {
            this.reason = theReasonElm.getFirstChild().getNodeValue();
            String theLang = theReasonElm.getAttribute(ATTR_LANG);
            if (theLang.length() > 0 && !theLang.equals(VALUE_LANG)) {
                this.setLanguage(theLang);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCheckResult clone = null;
        clone = (EPPRegistryCheckResult)super.clone();
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCheckResult)) {
            return false;
        }
        EPPRegistryCheckResult theComp = (EPPRegistryCheckResult)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            cat.error((Object)"EPPRegistryCheckResult: name not equal");
            return false;
        }
        if (!(this.available != null ? this.available.booleanValue() == theComp.available.booleanValue() : theComp.available == null)) {
            cat.error((Object)"EPPRegistryCheckResult: available not equal");
            return false;
        }
        if (!(this.language != null ? this.language.equals(theComp.language) : theComp.language == null)) {
            cat.error((Object)"EPPRegistryCheckResult: language not equal");
            return false;
        }
        if (!(this.reason != null ? this.reason.equals(theComp.reason) : theComp.reason == null)) {
            cat.error((Object)"EPPRegistryCheckResult: reason not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

