/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPOrgPendActionMsg
extends EPPResponse {
    private static Logger cat = Logger.getLogger((String)EPPOrgPendActionMsg.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "panData";
    public static final String ELM_NAME = "org:panData";
    private static final String ELM_ORG_ID = "id";
    private static final String ELM_PATRID = "paTRID";
    private static final String ELM_PENDING_DATE = "paDate";
    private static final String ATTR_RESULT = "paResult";
    private String orgId = null;
    private boolean paSuccess = false;
    EPPTransId pendingTransId = null;
    private Date pendingDate = null;

    public EPPOrgPendActionMsg() {
    }

    public EPPOrgPendActionMsg(EPPTransId aTransId, String aOrgId, boolean aSuccess, EPPTransId aPendingTransId, Date aPendingDate) {
        super(aTransId);
        this.orgId = aOrgId;
        this.paSuccess = aSuccess;
        this.setPendingTransId(aPendingTransId);
        this.pendingDate = aPendingDate;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String aOrgId) {
        this.orgId = aOrgId;
    }

    public Date getPendingDate() {
        return this.pendingDate;
    }

    public void setPendingDate(Date aPendingDate) {
        this.pendingDate = aPendingDate;
    }

    public EPPTransId getPendingTransId() {
        return this.pendingTransId;
    }

    public void setPendingTransId(EPPTransId pendingTransId) {
        this.pendingTransId = pendingTransId;
        this.pendingTransId.setRootName("urn:ietf:params:xml:ns:epp:org-1.0", "org:paTRID");
    }

    public boolean isPASuccess() {
        return this.paSuccess;
    }

    public void setPASuccess(boolean aSuccess) {
        this.paSuccess = aSuccess;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgPendActionMsg)) {
            cat.error((Object)("EPPOrgPendActionMsg.equals(): " + aObject.getClass().getName() + " not EPPOrgPendActionMsg instance"));
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error((Object)"EPPOrgPendActionMsg.equals(): super class not equal");
            return false;
        }
        EPPOrgPendActionMsg theComp = (EPPOrgPendActionMsg)aObject;
        if (!EqualityUtil.equals(this.orgId, theComp.orgId)) {
            cat.error((Object)"EPPOrgPendActionMsg.equals(): orgId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.paSuccess, theComp.paSuccess)) {
            cat.error((Object)"EPPOrgPendActionMsg.equals(): paSuccess not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.pendingTransId, theComp.pendingTransId)) {
            cat.error((Object)"EPPOrgPendActionMsg.equals(): pendingTransId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.pendingDate, theComp.pendingDate)) {
            cat.error((Object)"EPPOrgPendActionMsg.equals(): pendingDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgPendActionMsg clone = (EPPOrgPendActionMsg)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    void validateState() throws EPPCodecException {
        if (this.orgId == null) {
            cat.error((Object)"EPPOrgPendActionMsg.validateState(): required attribute orgId is not set");
            throw new EPPCodecException("required attribute orgId is not set");
        }
        if (this.pendingTransId == null) {
            cat.error((Object)"EPPOrgPendActionMsg.validateState(): required attribute pendingTransId is not set");
            throw new EPPCodecException("required attribute pendingTransId is not set");
        }
        if (this.pendingDate == null) {
            cat.error((Object)"EPPOrgPendActionMsg.validateState(): required attribute pendingDate is not set");
            throw new EPPCodecException("required attribute pendingDate is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPOrgPendActionMsg.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:id");
        root.appendChild(nameElm);
        if (this.paSuccess) {
            nameElm.setAttribute(ATTR_RESULT, "1");
        } else {
            nameElm.setAttribute(ATTR_RESULT, "0");
        }
        Text textNode = aDocument.createTextNode(this.orgId);
        nameElm.appendChild(textNode);
        EPPUtil.encodeComp(aDocument, root, this.pendingTransId);
        EPPUtil.encodeTimeInstant(aDocument, root, this.pendingDate, "urn:ietf:params:xml:ns:epp:org-1.0", "org:paDate");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ORG_ID);
        this.orgId = theNameElm.getFirstChild().getNodeValue();
        this.paSuccess = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_RESULT);
        this.pendingTransId = (EPPTransId)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_PATRID, EPPTransId.class);
        this.pendingDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_PENDING_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPOrgPendActionMsg.decode: " + e);
        }
    }
}

