/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResult;
import com.verisign.epp.codec.nv.EPPNameVerificationStatus;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPNameVerificationCreateFailed
implements EPPNameVerificationCreateResult {
    private static Logger cat = Logger.getLogger((String)EPPNameVerificationCreateFailed.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "failed";
    public static final String ELM_NAME = "nv:failed";
    private static final String ELM_STATUS = "status";
    private static final String ATTR_STATUS = "s";
    private static final String ELM_REASON = "msg";
    private static final String ATTR_LANG = "lang";
    private static final String VALUE_LANG = "en";
    private String reason;
    private String language = "en";
    private EPPNameVerificationStatus status;

    public EPPNameVerificationCreateFailed() {
    }

    public EPPNameVerificationCreateFailed(EPPNameVerificationStatus aStatus, String aReason) {
        this.status = aStatus;
        this.reason = aReason;
    }

    public EPPNameVerificationCreateFailed(EPPNameVerificationStatus aStatus, String aReason, String aLanguage) {
        this.status = aStatus;
        this.reason = aReason;
        this.language = aLanguage;
    }

    public EPPNameVerificationStatus getStatus() {
        return this.status;
    }

    public void setStatus(EPPNameVerificationStatus aStatus) {
        this.status = aStatus;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String aLanguage) {
        this.language = aLanguage;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.status == null) {
            throw new EPPEncodeException("Undefined status in EPPNameVerificationCreateFailed");
        }
        if (this.reason == null) {
            throw new EPPEncodeException("Undefined reason in EPPNameVerificationCreateFailed");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        Element theStatusElm = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:status");
        root.appendChild(theStatusElm);
        theStatusElm.setAttribute(ATTR_STATUS, this.status.toString());
        Element reason = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:msg");
        Text reasonVal = aDocument.createTextNode(this.reason);
        reason.appendChild(reasonVal);
        root.appendChild(reason);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_STATUS);
        String theStatusStr = theElm.getAttribute(ATTR_STATUS);
        this.status = EPPNameVerificationStatus.getStatus(theStatusStr);
        this.reason = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_REASON);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationCreateFailed clone = (EPPNameVerificationCreateFailed)super.clone();
        return clone;
    }

    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationCreateFailed)) {
            return false;
        }
        EPPNameVerificationCreateFailed other = (EPPNameVerificationCreateFailed)aObject;
        if (!EqualityUtil.equals((Object)this.status, (Object)other.status)) {
            cat.error((Object)"EPPNameVerificationCreateFailed.equals(): status not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, other.reason)) {
            cat.error((Object)"EPPNameVerificationCreateFailed.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.language, other.language)) {
            cat.error((Object)"EPPNameVerificationCreateFailed.equals(): language not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

