/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainNameVerification
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPDomainNameVerification.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "dnv";
    public static final String ELM_NAME = "nv:dnv";
    private static final String ELM_LABEL_NAME = "name";
    private static final String ELM_RNV_CODE = "rnvCode";
    private String name;
    private String rnvCode;

    public EPPDomainNameVerification() {
    }

    public EPPDomainNameVerification(String aName) {
        this.name = aName;
    }

    public EPPDomainNameVerification(String aName, String aRnvCode) {
        this.name = aName;
        this.rnvCode = aRnvCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasRnvCode() {
        return this.rnvCode != null;
    }

    public String getRnvCode() {
        return this.rnvCode;
    }

    public void setRnvCode(String aRnvCode) {
        this.rnvCode = aRnvCode;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("Undefined name in EPPDomainNameVerification");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:nv-1.0", "nv:name");
        if (this.hasRnvCode()) {
            EPPUtil.encodeString(aDocument, root, this.rnvCode, "urn:ietf:params:xml:ns:nv-1.0", "nv:rnvCode");
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_LABEL_NAME);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainNameVerification)) {
            cat.error((Object)("EPPDomainNameVerification.equals(): object " + aObject.getClass().getName() + "!= EPPDomainNameVerification"));
            return false;
        }
        EPPDomainNameVerification other = (EPPDomainNameVerification)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPDomainNameVerification.equals(): name not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainNameVerification clone = (EPPDomainNameVerification)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }
}

