/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.mark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPProtection
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPProtection.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "protection";
    public static final String ELM_NAME = "mark:protection";
    private static final String ELM_CC = "cc";
    private static final String ELM_REGION = "region";
    private static final String ELM_RULING = "ruling";
    private String cc;
    private String region;
    private List<String> rulings = new ArrayList<String>();

    public EPPProtection() {
    }

    public EPPProtection(String aCC, String aRegion) {
        this.cc = aCC;
        this.region = aRegion;
    }

    public EPPProtection(String aCC, String aRegion, String aRuling) {
        this.cc = aCC;
        this.region = aRegion;
        this.addRuling(aRuling);
    }

    public EPPProtection(String aCC, String aRegion, List<String> aRulings) {
        this.cc = aCC;
        this.region = aRegion;
        this.setRulings(aRulings);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPProtection clone = (EPPProtection)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPProtection.encode(Document)");
        }
        if (this.cc == null) {
            throw new EPPEncodeException("cc is required for protection");
        }
        if (this.region == null) {
            throw new EPPEncodeException("region is required for protection");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:mark-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.cc, "urn:ietf:params:xml:ns:mark-1.0", "mark:cc");
        EPPUtil.encodeString(aDocument, root, this.region, "urn:ietf:params:xml:ns:mark-1.0", "mark:region");
        EPPUtil.encodeList(aDocument, root, this.rulings, "urn:ietf:params:xml:ns:mark-1.0", "mark:ruling");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.cc = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_CC);
        this.region = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_REGION);
        this.rulings = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_RULING);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPProtection)) {
            cat.error((Object)"EPPProtection.equals(): aObject is not an EPPProtection");
            return false;
        }
        EPPProtection other = (EPPProtection)aObject;
        if (!EqualityUtil.equals(this.cc, other.cc)) {
            cat.error((Object)"EPPProtection.equals(): cc not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.region, other.region)) {
            cat.error((Object)"EPPProtection.equals(): region not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.rulings, other.rulings)) {
            cat.error((Object)"EPPProtection.equals(): rulings not equal");
            return false;
        }
        return true;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String aCc) {
        this.cc = aCc;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String aRegion) {
        this.region = aRegion;
    }

    public List<String> getRulings() {
        return this.rulings;
    }

    public void setRulings(List<String> aRulings) {
        this.rulings = aRulings;
        if (this.rulings == null) {
            this.rulings = new ArrayList<String>();
        }
    }

    public void addRuling(String aRuling) {
        if (this.rulings == null) {
            this.rulings = new ArrayList<String>();
        }
        this.rulings.add(aRuling);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:mark-1.0";
    }
}

