/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launchpolicy.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLaunchPolicyPhaseStatus
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchPolicyPhaseStatus.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "status";
    public static final String DEFAULT_LANG = "en";
    public static final String ELM_NAME = "lp:status";
    public static final String ATTR_STATUS = "s";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_LANG = "lang";
    private Status status;
    private String name;
    private String lang = "en";
    private String description = null;

    public EPPLaunchPolicyPhaseStatus() {
    }

    public EPPLaunchPolicyPhaseStatus(Status aStatus) {
        this.status = aStatus;
    }

    public EPPLaunchPolicyPhaseStatus(Status aStatus, String aName) {
        this.status = aStatus;
        this.name = aName;
    }

    public EPPLaunchPolicyPhaseStatus(Status aStatus, String aName, String aLang, String aDescription) {
        this.status = aStatus;
        this.name = aName;
        this.setLang(aLang);
        this.description = aDescription;
    }

    protected String getRootName() {
        return ELM_LOCALNAME;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (!this.hasStatus()) {
            throw new EPPEncodeException("status is null in EPPLaunchPolicyPhaseStatus.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_NAME);
        root.setAttribute(ATTR_STATUS, this.status.toString());
        if (this.hasName()) {
            root.setAttribute(ATTR_NAME, this.name);
        }
        if (this.hasDescription()) {
            root.setAttribute(ATTR_LANG, this.lang);
            Text theDescText = aDocument.createTextNode(this.description);
            root.appendChild(theDescText);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.status = Status.valueOf(aElement.getAttribute(ATTR_STATUS));
        this.name = EPPUtil.decodeStringAttr(aElement, ATTR_NAME);
        this.setLang(EPPUtil.decodeStringAttr(aElement, ATTR_LANG));
        this.description = EPPUtil.getTextContent(aElement, true);
        if (this.description != null && this.description.isEmpty()) {
            this.description = null;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchPolicyPhaseStatus)) {
            return false;
        }
        EPPLaunchPolicyPhaseStatus theComp = (EPPLaunchPolicyPhaseStatus)aObject;
        if (!EqualityUtil.equals(this.status, theComp.status)) {
            cat.error((Object)"EPPLaunchPolicyPhaseStatus.equals(): status not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error((Object)"EPPLaunchPolicyPhaseStatus.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lang, theComp.lang)) {
            cat.error((Object)"EPPLaunchPolicyPhaseStatus.equals(): lang not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, theComp.description)) {
            cat.error((Object)"EPPLaunchPolicyPhaseStatus.equals(): description not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status aStatus) {
        this.status = aStatus;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang == null ? DEFAULT_LANG : aLang;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDesc) {
        this.description = aDesc;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:launchPolicy-0.1";
    }

    public static enum Status implements Serializable,
    Cloneable
    {
        pendingValidation,
        validated,
        invalid,
        pendingAllocation,
        allocated,
        rejected,
        custom;

    }
}

