/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchCheckResult;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchChkData
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchChkData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "chkData";
    public static final String ELM_NAME = "launch:chkData";
    EPPLaunchPhase phase;
    private List<EPPLaunchCheckResult> results = new ArrayList<EPPLaunchCheckResult>();

    public EPPLaunchChkData() {
    }

    public EPPLaunchChkData(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public EPPLaunchChkData(EPPLaunchCheckResult aResult) {
        this.addCheckResult(aResult);
    }

    public EPPLaunchChkData(List<EPPLaunchCheckResult> aResults) {
        this.setCheckResults(aResults);
    }

    public EPPLaunchChkData(EPPLaunchPhase aPhase, EPPLaunchCheckResult aResult) {
        this.phase = aPhase;
        this.addCheckResult(aResult);
    }

    public EPPLaunchChkData(EPPLaunchPhase aPhase, List<EPPLaunchCheckResult> aResults) {
        this.phase = aPhase;
        this.setCheckResults(aResults);
    }

    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:launch-1.0";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchChkData)) {
            cat.error((Object)"EPPLaunchCheckResp.equals(): aObject is not an EPPLaunchCheckResp");
            return false;
        }
        EPPLaunchChkData other = (EPPLaunchChkData)aObject;
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error((Object)"EPPLaunchCheckResp.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.results, other.results)) {
            cat.error((Object)"EPPLaunchCheckResp.equals(): results not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchChkData clone = (EPPLaunchChkData)super.clone();
        clone.results = new ArrayList<EPPLaunchCheckResult>();
        for (EPPLaunchCheckResult result : this.results) {
            clone.results.add((EPPLaunchCheckResult)result.clone());
        }
        return clone;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public EPPLaunchPhase getPhase() {
        return this.phase;
    }

    public void setPhase(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public void setPhase(String aPhaseString) {
        this.phase = new EPPLaunchPhase(aPhaseString);
    }

    public List<EPPLaunchCheckResult> getCheckResults() {
        return this.results;
    }

    public void setCheckResults(List<EPPLaunchCheckResult> aResults) {
        this.results = aResults == null ? new ArrayList<EPPLaunchCheckResult>() : aResults;
    }

    public void addCheckResult(EPPLaunchCheckResult aResult) {
        this.results.add(aResult);
    }

    public void setCheckResult(EPPLaunchCheckResult aResult) {
        this.results = new ArrayList<EPPLaunchCheckResult>();
        this.results.add(aResult);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchCheckResp.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.phase);
        EPPUtil.encodeCompList(aDocument, root, this.results);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.phase = (EPPLaunchPhase)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:phase", EPPLaunchPhase.class);
        this.results = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:cd", EPPLaunchCheckResult.class);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

