/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPIdnTableInfoDomainTable
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPIdnTableInfoDomainTable.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "table";
    public static final String ELM_NAME = "idnTable:table";
    private static final String ELM_TABLE_NAME = "name";
    private static final String ELM_TYPE = "type";
    private static final String ELM_DESCRIPTION = "description";
    private static final String ATTR_LANG = "lang";
    private static final String ELM_VARIANT_GEN = "variantGen";
    private String name;
    private Type type;
    private String description;
    private String descriptionLang = "en";
    private Boolean variantGen;

    public EPPIdnTableInfoDomainTable() {
    }

    public EPPIdnTableInfoDomainTable(String aName, Type aType, String aDescription) {
        this.setName(aName);
        this.setType(aType);
        this.setDescription(aDescription);
    }

    public EPPIdnTableInfoDomainTable(String aName, Type aType, String aDescription, String aDescriptionLang, Boolean aVariantGen) {
        this.setName(aName);
        this.setType(aType);
        this.setDescription(aDescription);
        this.setDescriptionLang(aDescriptionLang);
        this.setVariantGen(aVariantGen);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type aType) {
        this.type = aType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public boolean hasDescriptionLang() {
        return this.descriptionLang != null;
    }

    public String getDescriptionLang() {
        return this.descriptionLang;
    }

    public void setDescriptionLang(String aDescriptionLang) {
        this.descriptionLang = aDescriptionLang;
    }

    public boolean hasVariantGen() {
        return this.variantGen != null;
    }

    public Boolean getVariantGen() {
        return this.variantGen;
    }

    public void setVariantGen(Boolean aVariantGen) {
        this.variantGen = aVariantGen;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("Undefined name in EPPIdnTableInfoDomainTable");
        }
        if (this.type == null) {
            throw new EPPEncodeException("Undefined type in EPPIdnTableInfoDomainTable");
        }
        if (this.description == null) {
            throw new EPPEncodeException("Undefined description in EPPIdnTableInfoDomainTable");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:name");
        switch (this.type) {
            case LANGUAGE: {
                EPPUtil.encodeString(aDocument, root, "language", "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:type");
                break;
            }
            case SCRIPT: {
                EPPUtil.encodeString(aDocument, root, "script", "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:type");
            }
        }
        Element descriptionElm = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:description");
        if (this.hasDescriptionLang()) {
            descriptionElm.setAttribute(ATTR_LANG, this.descriptionLang);
        }
        descriptionElm.appendChild(aDocument.createTextNode(this.description));
        root.appendChild(descriptionElm);
        EPPUtil.encodeBoolean(aDocument, root, this.variantGen, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:variantGen");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_TABLE_NAME);
        String theType = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_TYPE);
        this.type = theType == null ? null : (theType.equals("language") ? Type.LANGUAGE : Type.SCRIPT);
        Element theDescriptionElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_DESCRIPTION);
        if (theDescriptionElm != null) {
            Node textNode = theDescriptionElm.getFirstChild();
            if (textNode != null) {
                this.description = textNode.getNodeValue();
                String theDescriptionLang = theDescriptionElm.getAttribute(ATTR_LANG);
                this.descriptionLang = theDescriptionLang != null && !theDescriptionLang.isEmpty() ? theDescriptionLang : null;
            } else {
                this.description = null;
                this.descriptionLang = null;
            }
        } else {
            this.description = null;
            this.descriptionLang = null;
        }
        this.variantGen = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_VARIANT_GEN);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableInfoDomainTable clone = (EPPIdnTableInfoDomainTable)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableInfoDomainTable)) {
            return false;
        }
        EPPIdnTableInfoDomainTable other = (EPPIdnTableInfoDomainTable)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPIdnTableInfoDomainTable.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.type, (Object)other.type)) {
            cat.error((Object)"EPPIdnTableInfoDomainTable.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, other.description)) {
            cat.error((Object)"EPPIdnTableInfoDomainTable.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.descriptionLang, other.descriptionLang)) {
            cat.error((Object)"EPPIdnTableInfoDomainTable.equals(): descriptionLang not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.variantGen, other.variantGen)) {
            cat.error((Object)"EPPIdnTableInfoDomainTable.equals(): variantGen not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idnTable-1.0";
    }

    public static enum Type {
        LANGUAGE,
        SCRIPT;

    }
}

