/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainCreateCmd
extends EPPCreateCmd {
    static final String ELM_NAME = "domain:create";
    static final String ELM_REGISTRANT = "domain:registrant";
    private static final String ELM_DOMAIN_NAME = "domain:name";
    private static final String ELM_SERVER = "domain:ns";
    private static final String ELM_HOST_OBJ = "domain:hostObj";
    private static final String ELM_HOST_ATTR = "domain:hostAttr";
    private static final String ELM_CONTACT = "domain:contact";
    private static Logger cat = Logger.getLogger((String)EPPDomainCreateCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String name = null;
    private EPPDomainPeriod period = null;
    private Vector servers = null;
    private Vector contacts = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;

    public EPPDomainCreateCmd() {
        this.name = null;
        this.period = null;
        this.servers = null;
        this.contacts = null;
    }

    public EPPDomainCreateCmd(String aTransId, String aName, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        this.period = null;
        this.servers = null;
        this.contacts = null;
    }

    public EPPDomainCreateCmd(String aTransId, String aName, Vector someServers, Vector someContacts, EPPDomainPeriod aPeriod, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.period = aPeriod;
        this.servers = someServers;
        this.contacts = someContacts;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.authInfo == null) {
            throw new EPPCodecException("authInfo required attribute is not set");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Vector getServers() {
        return this.servers;
    }

    public void setServers(Vector aServers) {
        this.servers = aServers;
    }

    public void addServer(String aServer) {
        if (this.servers == null) {
            this.servers = new Vector();
        }
        this.servers.add(aServer);
    }

    public void addServer(EPPHostAttr aServer) {
        if (this.servers == null) {
            this.servers = new Vector();
        }
        this.servers.add(aServer);
    }

    public Vector getContacts() {
        return this.contacts;
    }

    public void setContacts(Vector aContacts) {
        this.contacts = aContacts;
    }

    public void addContact(EPPDomainContact aContact) {
        if (this.contacts == null) {
            this.contacts = new Vector();
        }
        this.contacts.add(aContact);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainCreateCmd)) {
            cat.error((Object)("EPPDomainCreateCmd.equals(): " + aObject.getClass().getName() + " not EPPDomainCreateCmd instance"));
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error((Object)"EPPDomainCreateCmd.equals(): super class not equal");
            return false;
        }
        EPPDomainCreateCmd theComp = (EPPDomainCreateCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            cat.error((Object)"EPPDomainCreateCmd.equals(): name not equal");
            return false;
        }
        if (!(this.period != null ? this.period.equals(theComp.period) : theComp.period == null)) {
            cat.error((Object)"EPPDomainCreateCmd.equals(): period not equal");
            return false;
        }
        if (!(this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null)) {
            cat.error((Object)"EPPDomainCreateCmd.equals(): authInfo not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.servers, theComp.servers)) {
            cat.error((Object)"EPPDomainCreateCmd.equals(): servers not equal");
            return false;
        }
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0") && !EPPUtil.equalVectors(this.contacts, theComp.contacts)) {
            cat.error((Object)"EPPDomainCreateCmd.equals(): contacts not equal");
            return false;
        }
        if (!(this.registrant != null ? this.registrant.equals(theComp.registrant) : theComp.registrant == null)) {
            cat.error((Object)"EPPDomainCreateCmd.equals(): registrant not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainCreateCmd clone = (EPPDomainCreateCmd)super.clone();
        if (this.servers != null) {
            clone.servers = (Vector)this.servers.clone();
        }
        if (this.contacts != null) {
            clone.contacts = (Vector)this.contacts.clone();
            for (int i = 0; i < this.contacts.size(); ++i) {
                clone.contacts.setElementAt(((EPPDomainContact)this.contacts.elementAt(i)).clone(), i);
            }
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.period != null) {
            clone.period = (EPPDomainPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public EPPDomainPeriod getPeriod() {
        return this.period;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    public void setPeriod(EPPDomainPeriod aPeriod) {
        this.period = aPeriod;
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPDomainCreateCmd.doEncode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPDomainCreateCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        root.setAttribute("xmlns:domain", "urn:ietf:params:xml:ns:domain-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        if (this.period != null && !this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        if (this.servers != null && this.servers.size() > 0) {
            Element theServersElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_SERVER);
            root.appendChild(theServersElm);
            Object theNS = this.servers.get(0);
            if (theNS instanceof String) {
                EPPUtil.encodeVector(aDocument, theServersElm, this.servers, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
            } else if (theNS instanceof EPPHostAttr) {
                EPPUtil.encodeCompVector(aDocument, theServersElm, this.servers);
            } else {
                throw new EPPEncodeException("EPPDomainCreateCmd.encode: Invalid NS server class " + theNS.getClass().getName());
            }
        }
        if (this.registrant != null) {
            EPPUtil.encodeString(aDocument, root, this.registrant, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
        }
        if (this.contacts != null) {
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                EPPUtil.encodeCompVector(aDocument, root, this.contacts);
            } else {
                throw new EPPEncodeException("Contacts specified when the Contact Mapping is not supported");
            }
        }
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theServerElm;
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.period = (EPPDomainPeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:period", EPPDomainPeriod.class);
        Element theServersElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_SERVER);
        if (theServersElm != null && (theServerElm = EPPUtil.getFirstElementChild(theServersElm)) != null) {
            if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_OBJ))) {
                this.servers = EPPUtil.decodeVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
            } else if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_ATTR))) {
                this.servers = EPPUtil.decodeCompVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_ATTR, EPPHostAttr.class);
            } else {
                throw new EPPDecodeException("EPPDomainCreateCmd.doDecode: Invalid host child element " + theServersElm.getLocalName());
            }
            if (this.servers.size() == 0) {
                this.servers = null;
            }
        }
        this.registrant = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
        this.contacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CONTACT, EPPDomainContact.class);
        if (this.contacts.size() == 0) {
            this.contacts = null;
        }
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo", EPPAuthInfo.class);
    }
}

