/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.util;

import com.codestudio.util.ObjectPool;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class PoolManager
implements Serializable {
    protected Hashtable pools = new Hashtable(1);
    protected ObjectPool defaultpool = null;

    protected PoolManager() {
    }

    public Enumeration getAllPoolnames() {
        return this.pools.keys();
    }

    public ObjectPool getPool(String string) {
        if (string == null) {
            return this.defaultpool;
        }
        if (this.pools.containsKey(string)) {
            try {
                return (ObjectPool)this.pools.get(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        throw new NullPointerException("ERROR: Could not locate " + string + ". This usually means that the " + "poolman.xml" + " file could not be found, or that it " + "does not contain configuration data for a " + "pool with a name equal to " + string);
    }

    public void addPool(String string, ObjectPool objectPool) {
        if (this.pools.containsKey(string)) {
            System.out.println("ERROR: A pool identified by the id " + string + " already exists, ignoring it.");
        } else {
            this.pools.put(string, objectPool);
            if (this.defaultpool == null) {
                this.defaultpool = objectPool;
            }
        }
    }

    public void removePool(String string) {
        if (this.pools.containsKey(string)) {
            int n;
            int n2 = this.defaultpool.hashCode();
            if (n2 == (n = this.pools.get(string).hashCode())) {
                this.defaultpool = null;
            }
            this.pools.remove(string);
        }
    }

    public Object requestObject() {
        try {
            return this.defaultpool.checkOut();
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not request object, returning NULL:");
            return null;
        }
    }

    public Object requestObject(String string) {
        ObjectPool objectPool = null;
        try {
            objectPool = (ObjectPool)this.pools.get(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (objectPool != null) {
            try {
                return objectPool.checkOut();
            }
            catch (Exception exception) {
                System.out.println("ERROR: Could not request object, returning NULL:");
            }
        }
        return null;
    }

    public void returnObject(Object object) {
        this.defaultpool.checkIn(object);
    }

    public void returnObject(Object object, String string) {
        ObjectPool objectPool = null;
        try {
            objectPool = (ObjectPool)this.pools.get(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (objectPool != null) {
            objectPool.checkIn(object);
        }
    }

    public void destroyPools() {
        if (this.pools != null) {
            Enumeration enumeration = this.pools.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                ObjectPool objectPool = (ObjectPool)this.pools.get(k);
                objectPool.closeAllResources();
            }
        }
    }
}

