/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport;

import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggerFactory;

public class EPPClientConTst {
    private static Logger cat = Logger.getLogger((String)EPPClientConTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPClientCon myClient = null;
    private InputStream myInputStream = null;
    private OutputStream myOutputStream = null;

    public EPPClientCon mkEPPClientCon(String newSocketClient) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (EPPClientCon)Class.forName(newSocketClient).newInstance();
    }

    public static void main(String[] args) {
        EPPClientConTst myInstance = new EPPClientConTst();
        EPPEnvSingle env = EPPEnvSingle.getInstance();
        if (args.length == 0) {
            System.out.println("EPP Configuration File must be specified");
            System.exit(1);
        }
        try {
            env.initialize(args[0]);
        }
        catch (EPPEnvException e) {
            System.out.println("EPPEvnException is thrown :" + e.getMessage());
            System.exit(1);
        }
        try {
            Logger root = Logger.getRootLogger();
            root.setLevel(EPPEnv.getLogLevel());
            root.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), EPPEnv.getLogFile(), true));
        }
        catch (EPPEnvException e) {
            System.out.println("EPPEnvException When intializing Log " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("IOException When intializing Log " + e.getMessage());
            System.exit(1);
        }
        cat.debug((Object)"Starting Client Socket ");
        try {
            myInstance.myClient = myInstance.mkEPPClientCon(EPPEnv.getClientSocketName());
        }
        catch (EPPEnvException myException) {
            cat.error((Object)("EPPEnvException When Selecting Client " + myException.getMessage()), (Throwable)myException);
            System.out.println("EPPEnvException When Selecting Client " + myException.getMessage());
            System.exit(1);
        }
        catch (ClassNotFoundException myException) {
            cat.error((Object)("Class Not Found Exception : " + myException.getMessage()), (Throwable)myException);
            System.out.println("Class Not Found Exception : " + myException.getMessage());
            System.exit(1);
        }
        catch (InstantiationException myException) {
            cat.error((Object)("Instantiation Exception : " + myException.getMessage()), (Throwable)myException);
            System.out.println("Instantiation Exception : " + myException.getMessage());
            System.exit(1);
        }
        catch (IllegalAccessException myException) {
            cat.error((Object)("Illegal Access Exception : " + myException.getMessage()), (Throwable)myException);
            System.out.println("Illegal Access Exception : " + myException.getMessage());
            System.exit(1);
        }
        try {
            myInstance.myClient.initialize();
        }
        catch (EPPConException myException) {
            cat.error((Object)("got EPP Connection Exception when initiallizing : " + myException.getMessage()), (Throwable)myException);
            System.out.println("got EPP Connection Exception when initiallizing : " + myException.getMessage());
            System.exit(1);
        }
        try {
            myInstance.myOutputStream = myInstance.myClient.getOutputStream();
            myInstance.myInputStream = myInstance.myClient.getInputStream();
        }
        catch (EPPConException myException) {
            cat.error((Object)("EPP Connection Exception getting I/O Stream : " + myException.getMessage()), (Throwable)myException);
            System.out.println("EPP Connection Exception getting I/O Stream : " + myException.getMessage());
            System.exit(1);
        }
        PrintWriter out = null;
        BufferedReader in = null;
        out = new PrintWriter(myInstance.myOutputStream, true);
        in = new BufferedReader(new InputStreamReader(myInstance.myInputStream));
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        try {
            String fromServer;
            while ((fromServer = in.readLine()) != null) {
                System.out.println("Server: " + fromServer);
                if (!fromServer.equals("Bye.")) {
                    out.println("Bye.");
                    continue;
                }
                break;
            }
        }
        catch (IOException myException) {
            cat.error((Object)("IO Exception while perform IO with Socket : " + myException.getMessage()), (Throwable)myException);
            System.out.println("IO Exception while perform IO with Socket : " + myException.getMessage());
            System.exit(1);
        }
        out.close();
        try {
            in.close();
        }
        catch (IOException myException) {
            cat.error((Object)("IO Exception when closing Socket BufferedReader : " + myException.getMessage()), (Throwable)myException);
            System.out.println("IO Exception when closing Socket BufferedReader : " + myException.getMessage());
            System.exit(1);
        }
        try {
            stdIn.close();
        }
        catch (IOException myException) {
            cat.error((Object)("IO Exception when closing Client BufferedReader : " + myException.getMessage()), (Throwable)myException);
            System.out.println("IO Exception when closing Client BufferedReader : " + myException.getMessage());
            System.exit(1);
        }
        try {
            myInstance.myClient.close();
        }
        catch (EPPConException myException) {
            cat.error((Object)("got EPP Connection Exception when initiallizing : " + myException.getMessage()), (Throwable)myException);
            System.out.println("got EPP Connection Exception when initiallizing : " + myException.getMessage());
            System.exit(1);
        }
    }
}

