/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.v11;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.fee.v11.EPPFeeCheck;
import com.verisign.epp.codec.fee.v11.EPPFeeChkData;
import com.verisign.epp.codec.fee.v11.EPPFeeCreData;
import com.verisign.epp.codec.fee.v11.EPPFeeCreate;
import com.verisign.epp.codec.fee.v11.EPPFeeCredit;
import com.verisign.epp.codec.fee.v11.EPPFeeDelData;
import com.verisign.epp.codec.fee.v11.EPPFeeObjectResult;
import com.verisign.epp.codec.fee.v11.EPPFeePeriod;
import com.verisign.epp.codec.fee.v11.EPPFeeRenData;
import com.verisign.epp.codec.fee.v11.EPPFeeRenew;
import com.verisign.epp.codec.fee.v11.EPPFeeTransfer;
import com.verisign.epp.codec.fee.v11.EPPFeeTrnData;
import com.verisign.epp.codec.fee.v11.EPPFeeUpdData;
import com.verisign.epp.codec.fee.v11.EPPFeeUpdate;
import com.verisign.epp.codec.fee.v11.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.serverstub.FeeSubDomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class FeeV11DomainHandler
implements FeeSubDomainHandler {
    private static Logger cat = Logger.getLogger((String)FeeV11DomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    public void doDomainCheck(EPPDomainCheckCmd aCheckCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainCheck: fee check extension = " + (EPPFeeCheck)aCheckCommand.getExtension(EPPFeeCheck.class)));
        EPPFeeChkData theChkDataExt = new EPPFeeChkData();
        EPPFeeCheck theFeeExt = (EPPFeeCheck)aCheckCommand.getExtension(EPPFeeCheck.class);
        for (String domain : aCheckCommand.getNames()) {
            EPPFeeObjectResult theFeeResult = new EPPFeeObjectResult();
            theFeeResult.setObjXmlNs("urn:ietf:params:xml:ns:domain-1.0");
            theFeeResult.setObjXmlName("domain:name");
            theFeeResult.setObjID(domain);
            theFeeResult.setCommand(theFeeExt.getCommand());
            theFeeResult.setPeriod(theFeeExt.getPeriod());
            if (theFeeExt.hasCurrency()) {
                theFeeResult.setCurrency(theFeeExt.getCurrency());
            } else {
                theFeeResult.setCurrency("USD");
            }
            if (domain.equalsIgnoreCase("example.com")) {
                theFeeResult.setAvailable(true);
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Registration Fee", true, null, null));
            } else if (domain.equalsIgnoreCase("example.net")) {
                theFeeResult.setAvailable(true);
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Registration Fee", true, null, null));
            } else if (domain.equalsIgnoreCase("example.xyz")) {
                theFeeResult.setAvailable(false);
                theFeeResult.setReason("minimum period is 2 years.");
            } else {
                theFeeResult.setAvailable(true);
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Application Fee", true, "P5D", EPPFeeValue.APPLIED_DELAYED));
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Registration Fee", true, "P20D", EPPFeeValue.APPLIED_IMMEDIATE));
                theFeeResult.setClassification("Test Classification");
            }
            theChkDataExt.addCheckResult(theFeeResult);
        }
        aResponse.addExtension(theChkDataExt);
    }

    @Override
    public void doDomainInfo(EPPDomainInfoCmd aInfoCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)"doDomainInfo: do nothing for info command");
    }

    @Override
    public void doDomainCreate(EPPDomainCreateCmd aCreateCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainCreate: fee create extension = " + (EPPFeeCreate)aCreateCommand.getExtension(EPPFeeCreate.class)));
        EPPFeeCreData theCreData = new EPPFeeCreData();
        EPPFeeCreate theFeeExt = (EPPFeeCreate)aCreateCommand.getExtension(EPPFeeCreate.class);
        theCreData.setFees(theFeeExt.getFees());
        theCreData.setCurrency("USD");
        theCreData.setBalance(new BigDecimal("-5.00"));
        theCreData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theCreData);
    }

    @Override
    public void doDomainDelete(EPPDomainDeleteCmd aDeleteCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainDelete: fee delete extension to be added for " + aDeleteCommand.getName()));
        EPPFeeDelData theRespExt = new EPPFeeDelData("USD", new EPPFeeCredit(new BigDecimal("-5.00"), "AGP Credit"));
        theRespExt.setBalance(new BigDecimal("1005.00"));
        aResponse.addExtension(theRespExt);
    }

    @Override
    public void doDomainRenew(EPPDomainRenewCmd aRenewCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainRenew: fee renew extension = " + (EPPFeeRenew)aRenewCommand.getExtension(EPPFeeRenew.class)));
        EPPFeeRenData theRenData = new EPPFeeRenData();
        EPPFeeRenew theFeeExt = (EPPFeeRenew)aRenewCommand.getExtension(EPPFeeRenew.class);
        theRenData.setFees(theFeeExt.getFees());
        theRenData.setCurrency("USD");
        theRenData.setBalance(new BigDecimal("-5.00"));
        theRenData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theRenData);
    }

    @Override
    public void doDomainUpdate(EPPDomainUpdateCmd aUpdateCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainUpdate: fee update extension = " + (EPPFeeUpdate)aUpdateCommand.getExtension(EPPFeeUpdate.class)));
        EPPFeeUpdData theUpdData = new EPPFeeUpdData();
        EPPFeeUpdate theFeeExt = (EPPFeeUpdate)aUpdateCommand.getExtension(EPPFeeUpdate.class);
        theUpdData.setFees(theFeeExt.getFees());
        theUpdData.setCurrency("USD");
        theUpdData.setBalance(new BigDecimal("-5.00"));
        theUpdData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theUpdData);
    }

    @Override
    public void doDomainTransfer(EPPDomainTransferCmd aTransferCommand, EPPResponse aResponse, Object aData) {
        if (aTransferCommand.getOp().equals("query")) {
            EPPFeeTrnData theTrnData = new EPPFeeTrnData("USD", new EPPFeeValue(new BigDecimal("5.00")));
            theTrnData.setPeriod(new EPPFeePeriod(1));
            aResponse.addExtension(theTrnData);
        } else if (aTransferCommand.getOp().equals("request")) {
            if (aTransferCommand.hasExtension(EPPFeeTransfer.class)) {
                cat.info((Object)("doDomainTransfer: fee transfer request extension = " + (EPPFeeTransfer)aTransferCommand.getExtension(EPPFeeTransfer.class)));
                EPPFeeTransfer theFeeExt = (EPPFeeTransfer)aTransferCommand.getExtension(EPPFeeTransfer.class);
                EPPFeeTrnData theTrnData = new EPPFeeTrnData();
                theTrnData.setFees(theFeeExt.getFees());
                theTrnData.setCurrency("USD");
                theTrnData.setBalance(new BigDecimal("-5.00"));
                theTrnData.setCreditLimit(new BigDecimal("1000.00"));
                aResponse.addExtension(theTrnData);
            } else {
                cat.info((Object)"doDomainTransfer: fee transfer request = null");
                System.out.println("doDomainTransfer: fee transfer request = null");
            }
        }
    }
}

