/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.v06;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.fee.v06.EPPFeeCheck;
import com.verisign.epp.codec.fee.v06.EPPFeeChkData;
import com.verisign.epp.codec.fee.v06.EPPFeeCreData;
import com.verisign.epp.codec.fee.v06.EPPFeeCreate;
import com.verisign.epp.codec.fee.v06.EPPFeeCredit;
import com.verisign.epp.codec.fee.v06.EPPFeeDelData;
import com.verisign.epp.codec.fee.v06.EPPFeeDomain;
import com.verisign.epp.codec.fee.v06.EPPFeeDomainResult;
import com.verisign.epp.codec.fee.v06.EPPFeeInfData;
import com.verisign.epp.codec.fee.v06.EPPFeeInfo;
import com.verisign.epp.codec.fee.v06.EPPFeePeriod;
import com.verisign.epp.codec.fee.v06.EPPFeeRenData;
import com.verisign.epp.codec.fee.v06.EPPFeeRenew;
import com.verisign.epp.codec.fee.v06.EPPFeeTransfer;
import com.verisign.epp.codec.fee.v06.EPPFeeTrnData;
import com.verisign.epp.codec.fee.v06.EPPFeeUpdData;
import com.verisign.epp.codec.fee.v06.EPPFeeUpdate;
import com.verisign.epp.codec.fee.v06.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.serverstub.FeeSubDomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class FeeV06DomainHandler
implements FeeSubDomainHandler {
    private static Logger cat = Logger.getLogger((String)FeeV06DomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    public void doDomainCheck(EPPDomainCheckCmd aCheckCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainCheck: fee check extension = " + (EPPFeeCheck)aCheckCommand.getExtension(EPPFeeCheck.class)));
        EPPFeeChkData theChkDataExt = new EPPFeeChkData();
        EPPFeeCheck theFeeExt = (EPPFeeCheck)aCheckCommand.getExtension(EPPFeeCheck.class);
        for (EPPFeeDomain domain : theFeeExt.getDomains()) {
            EPPFeeDomainResult theFeeResult = new EPPFeeDomainResult();
            theFeeResult.setName(domain.getName());
            theFeeResult.setCommand(domain.getCommand());
            theFeeResult.setPeriod(domain.getPeriod());
            if (domain.hasCurrency()) {
                theFeeResult.getCurrency();
            } else {
                theFeeResult.setCurrency("USD");
            }
            if (domain.getName().equalsIgnoreCase("example.com")) {
                theFeeResult.setCurrency("USD");
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Application Fee", false, null, EPPFeeValue.APPLIED_IMMEDIATE));
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Registration Fee", true, null, null));
            } else if (domain.getName().equalsIgnoreCase("example.net")) {
                theFeeResult.setCurrency("EUR");
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00")));
            } else if (domain.getName().equalsIgnoreCase("example.org")) {
                theFeeResult.setCurrency("EUR");
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("2.50"), "Transfer Fee", true, null, null));
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("10.00"), "Renewal Fee", true, null, null));
            } else if (domain.getName().equalsIgnoreCase("example.xyz")) {
                theFeeResult.setCurrency("GDB");
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("25.00"), "Restore Fee", true, null, EPPFeeValue.APPLIED_IMMEDIATE));
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Renewal Fee", true, null, EPPFeeValue.APPLIED_IMMEDIATE));
            } else {
                theFeeResult.setCurrency("USD");
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Application Fee", true, "P5D", EPPFeeValue.APPLIED_DELAYED));
                theFeeResult.addFee(new EPPFeeValue(new BigDecimal("5.00"), "Registration Fee", true, "P20D", EPPFeeValue.APPLIED_IMMEDIATE));
                theFeeResult.setClassification("Test Classification");
            }
            theChkDataExt.addCheckResult(theFeeResult);
        }
        aResponse.addExtension(theChkDataExt);
    }

    @Override
    public void doDomainInfo(EPPDomainInfoCmd aInfoCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainInfo: fee info extension = " + (EPPFeeInfo)aInfoCommand.getExtension(EPPFeeInfo.class)));
        EPPFeeInfData theInfData = new EPPFeeInfData();
        EPPFeeInfo theFeeExt = (EPPFeeInfo)aInfoCommand.getExtension(EPPFeeInfo.class);
        theInfData.setCommand(theFeeExt.getCommand());
        theInfData.setPeriod(theFeeExt.getPeriod());
        if (theFeeExt.hasCurrency()) {
            theInfData.setCurrency(theFeeExt.getCurrency());
        } else {
            theInfData.setCurrency("USD");
        }
        theInfData.addFee(new EPPFeeValue(new BigDecimal("10.00"), null, true, "P5D", EPPFeeValue.APPLIED_IMMEDIATE));
        theInfData.setClassification("premium-tier1");
        aResponse.addExtension(theInfData);
    }

    @Override
    public void doDomainCreate(EPPDomainCreateCmd aCreateCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainCreate: fee create extension = " + (EPPFeeCreate)aCreateCommand.getExtension(EPPFeeCreate.class)));
        EPPFeeCreData theCreData = new EPPFeeCreData();
        EPPFeeCreate theFeeExt = (EPPFeeCreate)aCreateCommand.getExtension(EPPFeeCreate.class);
        theCreData.setFees(theFeeExt.getFees());
        theCreData.setCurrency(theFeeExt.getCurrency());
        theCreData.setBalance(new BigDecimal("-5.00"));
        theCreData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theCreData);
    }

    @Override
    public void doDomainDelete(EPPDomainDeleteCmd aDeleteCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainDelete: fee delete extension to be added for " + aDeleteCommand.getName()));
        EPPFeeDelData theRespExt = new EPPFeeDelData("USD", new EPPFeeCredit(new BigDecimal("-5.00"), "AGP Credit"));
        theRespExt.setBalance(new BigDecimal("1005.00"));
        aResponse.addExtension(theRespExt);
    }

    @Override
    public void doDomainRenew(EPPDomainRenewCmd aRenewCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainRenew: fee renew extension = " + (EPPFeeRenew)aRenewCommand.getExtension(EPPFeeRenew.class)));
        EPPFeeRenData theRenData = new EPPFeeRenData();
        EPPFeeRenew theFeeExt = (EPPFeeRenew)aRenewCommand.getExtension(EPPFeeRenew.class);
        theRenData.setFees(theFeeExt.getFees());
        theRenData.setCurrency(theFeeExt.getCurrency());
        theRenData.setBalance(new BigDecimal("-5.00"));
        theRenData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theRenData);
    }

    @Override
    public void doDomainUpdate(EPPDomainUpdateCmd aUpdateCommand, EPPResponse aResponse, Object aData) {
        cat.info((Object)("doDomainUpdate: fee update extension = " + (EPPFeeUpdate)aUpdateCommand.getExtension(EPPFeeUpdate.class)));
        EPPFeeUpdData theUpdData = new EPPFeeUpdData();
        EPPFeeUpdate theFeeExt = (EPPFeeUpdate)aUpdateCommand.getExtension(EPPFeeUpdate.class);
        theUpdData.setFees(theFeeExt.getFees());
        theUpdData.setCurrency(theFeeExt.getCurrency());
        theUpdData.setBalance(new BigDecimal("-5.00"));
        theUpdData.setCreditLimit(new BigDecimal("1000.00"));
        aResponse.addExtension(theUpdData);
    }

    @Override
    public void doDomainTransfer(EPPDomainTransferCmd aTransferCommand, EPPResponse aResponse, Object aData) {
        if (aTransferCommand.getOp().equals("query")) {
            EPPFeeTrnData theTrnData = new EPPFeeTrnData("USD", new EPPFeeValue(new BigDecimal("5.00")));
            theTrnData.setPeriod(new EPPFeePeriod(1));
            aResponse.addExtension(theTrnData);
        } else if (aTransferCommand.getOp().equals("request")) {
            if (aTransferCommand.hasExtension(EPPFeeTransfer.class)) {
                cat.info((Object)("doDomainTransfer: fee transfer request extension = " + (EPPFeeTransfer)aTransferCommand.getExtension(EPPFeeTransfer.class)));
                EPPFeeTransfer theFeeExt = (EPPFeeTransfer)aTransferCommand.getExtension(EPPFeeTransfer.class);
                EPPFeeTrnData theTrnData = new EPPFeeTrnData();
                theTrnData.setFees(theFeeExt.getFees());
                theTrnData.setCurrency(theFeeExt.getCurrency());
                theTrnData.setBalance(new BigDecimal("-5.00"));
                theTrnData.setCreditLimit(new BigDecimal("1000.00"));
                aResponse.addExtension(theTrnData);
            } else {
                cat.info((Object)"doDomainTransfer: fee transfer request = null");
                System.out.println("doDomainTransfer: fee transfer request = null");
            }
        }
    }
}

