/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.reseller.EPPResellerAddress;
import com.verisign.epp.codec.reseller.EPPResellerCheckCmd;
import com.verisign.epp.codec.reseller.EPPResellerCheckResp;
import com.verisign.epp.codec.reseller.EPPResellerCheckResult;
import com.verisign.epp.codec.reseller.EPPResellerContact;
import com.verisign.epp.codec.reseller.EPPResellerCreateCmd;
import com.verisign.epp.codec.reseller.EPPResellerCreateResp;
import com.verisign.epp.codec.reseller.EPPResellerDeleteCmd;
import com.verisign.epp.codec.reseller.EPPResellerDisclose;
import com.verisign.epp.codec.reseller.EPPResellerInfoCmd;
import com.verisign.epp.codec.reseller.EPPResellerInfoResp;
import com.verisign.epp.codec.reseller.EPPResellerPostalDefinition;
import com.verisign.epp.codec.reseller.EPPResellerUpdateCmd;
import com.verisign.epp.codec.reseller.State;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPResellerHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class ResellerHandler
extends EPPResellerHandler {
    private static Logger cat = Logger.getLogger((String)ResellerHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doResellerCheck(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doResellerCheck: enter");
        EPPResellerCheckCmd theCommand = (EPPResellerCheckCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResellerCheckResp theResp = new EPPResellerCheckResp(theTransId);
        for (String resellerId : theCommand.getResellerIds()) {
            if (resellerId.equalsIgnoreCase("re1523") || resellerId.equalsIgnoreCase("notavailable")) {
                theResp.addCheckResult(new EPPResellerCheckResult(resellerId, "In use"));
                continue;
            }
            theResp.addCheckResult(new EPPResellerCheckResult(resellerId, true));
        }
        cat.debug((Object)"doResellerCheck: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doResellerInfo(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doResellerInfo: enter");
        EPPResellerInfoCmd theCommand = (EPPResellerInfoCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResellerInfoResp theResp = new EPPResellerInfoResp(theTransId, theCommand.getResellerId());
        theResp.setRoid("res1523-REP");
        theResp.setState(State.OK);
        theResp.setParentId("1523res");
        EPPResellerAddress theAddress = new EPPResellerAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        theResp.addPostalInfo(new EPPResellerPostalDefinition(EPPResellerPostalDefinition.Type.INT, "Example Reseller Inc.", theAddress));
        theResp.setVoice("+1.7035555555");
        theResp.setVoiceExt("1234");
        theResp.setFax("+1.7035555556");
        theResp.setEmail("contact@reseller.example");
        theResp.setUrl("http://reseller.example");
        theResp.addContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.ADMINISTRATIVE));
        theResp.addContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.BILLING));
        theResp.setClientId("ClientY");
        theResp.setCreatedBy("ClientX");
        theResp.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResp.setLastUpdatedBy("ClientX");
        theResp.setLastUpdatedDate(new GregorianCalendar(1999, 12, 3, 0, 0).getTime());
        EPPResellerDisclose disclose = new EPPResellerDisclose(false);
        disclose.setVoice(true);
        disclose.setEmail(true);
        theResp.setDisclose(disclose);
        cat.debug((Object)"doResellerInfo: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doResellerCreate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doResellerCreate: enter");
        EPPResellerCreateCmd theCommand = (EPPResellerCreateCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResellerCreateResp theResp = new EPPResellerCreateResp(theTransId, theCommand.getResellerId(), new Date());
        theResp.setResellerId(theCommand.getResellerId());
        cat.debug((Object)"doResellerCreate: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doResellerDelete(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doResellerDelete: enter");
        EPPResellerDeleteCmd theCommand = (EPPResellerDeleteCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResp = new EPPResponse(theTransId);
        cat.debug((Object)"doResellerDelete: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doResellerUpdate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doResellerUpdate: enter");
        EPPResellerUpdateCmd theCommand = (EPPResellerUpdateCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResp = new EPPResponse(theTransId);
        cat.debug((Object)"doResellerUpdate: exit");
        return new EPPEventResponse(theResp);
    }
}

