/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.EPPSessionPool;
import com.verisign.epp.pool.EPPSessionPoolException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.InvalidateSessionException;
import com.verisign.epp.util.TestThread;
import com.verisign.epp.util.TestUtil;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSessionPoolTst
extends TestCase {
    protected static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    protected static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPSessionPoolTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    protected static EPPSessionPool sessionPool = null;

    public EPPSessionPoolTst(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHello() {
        EPPSessionPoolTst.printStart("testHello");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            theSession.hello();
        }
        catch (EPPCommandException ex) {
            try {
                sessionPool.invalidateObject(theSession);
                theSession = null;
            }
            catch (EPPSessionPoolException ePPSessionPoolException) {
                // empty catch block
            }
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        EPPSessionPoolTst.printEnd("testHello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPoll() {
        EPPSessionPoolTst.printStart("testPoll");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            EPPResponse response = null;
            Long numMsgs = null;
            try {
                theSession.setTransId("ABC-12345-XYZ");
                theSession.setPollOp("req");
                response = theSession.sendPoll();
                System.out.println("doPoll: Response = [" + response + "]\n\n");
                numMsgs = response.getMsgQueueCount();
                if (numMsgs != null) {
                    System.out.println("doPoll: # messages = " + numMsgs);
                }
            }
            catch (EPPCommandException e) {
                TestUtil.handleException(theSession, e);
            }
            try {
                theSession.setTransId("ABC-12345-XYZ");
                theSession.setPollOp("ack");
                theSession.setMsgID("1234");
                response = theSession.sendPoll();
                System.out.println("doPoll: Response = [" + response + "]\n\n");
            }
            catch (EPPCommandException e) {
                System.out.println("doPoll: Error Response = [" + e.getResponse() + "]\n\n");
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        EPPSessionPoolTst.printEnd("testPoll");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloseSession() {
        EPPSessionPoolTst.printStart("testCloseSession");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            try {
                theSession.setTransId("CLOSE-SESSION-TEST");
                theSession.setPollOp("ack");
                theSession.setMsgID("CLOSE-SESSION-TEST");
                theSession.sendPoll();
                Assert.fail((String)"testCloseSession: Expcted error for poll ack of CLOSE-SESSION-TEST");
            }
            catch (EPPCommandException e) {
                System.out.println("testCloseSession: Got expected exception = [" + e + "], check for any CLOSE_WAIT connections\n\n");
                this.invalidateSession(theSession);
                Assert.assertNull((Object)theSession.getInputStream());
                theSession = null;
            }
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        EPPSessionPoolTst.printEnd("testCloseSession");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEndSession() {
        EPPSessionPoolTst.printStart("testEndSession");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            this.invalidateSession(theSession);
            theSession = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("testEndSession(): Exception invalidating session: " + ex));
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        EPPSessionPoolTst.printEnd("testEndSession");
    }

    public void testAbsoluteTimeout() {
        EPPSessionPoolTst.printStart("testAbsoluteTimeout");
        System.out.println("testAbsolutionTimeout: active = " + sessionPool.getGenericObjectPool().getNumActive() + ", idle = " + sessionPool.getGenericObjectPool().getNumIdle());
        if (sessionPool.getAbsoluteTimeout() > 10000L) {
            System.out.println("testAbsolutionTimeout: Do nothing since absolute timeout of " + sessionPool.getAbsoluteTimeout() + " > 10000");
        } else {
            System.out.println("Sleeping for " + (sessionPool.getAbsoluteTimeout() + 1000L) + " ms");
            try {
                Thread.currentThread();
                Thread.sleep(sessionPool.getAbsoluteTimeout() + 1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("testAbsolutionTimeout: active = " + sessionPool.getGenericObjectPool().getNumActive() + ", idle = " + sessionPool.getGenericObjectPool().getNumIdle());
        }
        EPPSessionPoolTst.printEnd("testAbsoluteTimeout");
    }

    public void testIdleTimeout() {
        EPPSessionPoolTst.printStart("testIdleTimeout");
        if (sessionPool.getIdleTimeout() > 10000L) {
            System.out.println("testIdleTimeout: Do nothing since idle timeout of " + sessionPool.getIdleTimeout() + " > 10000");
        } else {
            System.out.println("Sleeping for " + (sessionPool.getIdleTimeout() + 1000L) + " ms");
            try {
                Thread.currentThread();
                Thread.sleep(sessionPool.getIdleTimeout() + 1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("testIdleTimeout: Look for epp.log messages containing text \"is past idle timeout, sending hello\"");
        }
        EPPSessionPoolTst.printEnd("testIdleTimeout");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPSessionPoolTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        try {
            sessionPool = EPPSessionPool.getInstance();
            sessionPool.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Error initializing the session pool: " + ex));
        }
        return suite;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionPoolTst Thread " + i, EPPSessionPoolTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSessionPoolTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " Start"));
        }
        cat.info((Object)(aTest + ": start"));
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " End"));
        }
        cat.info((Object)(aTest + ": end"));
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    protected EPPSession borrowSession() {
        EPPSession theSession = null;
        try {
            theSession = sessionPool.borrowObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("borrowSession(): Exception borrowing session: " + ex));
        }
        return theSession;
    }

    protected void invalidateSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.invalidateObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception invalidating session: " + ex));
        }
    }

    protected void returnSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.returnObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception returning session: " + ex));
        }
    }
}

