/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.reseller.EPPResellerCheckCmd;
import com.verisign.epp.codec.reseller.EPPResellerCheckResp;
import com.verisign.epp.codec.reseller.EPPResellerContact;
import com.verisign.epp.codec.reseller.EPPResellerCreateCmd;
import com.verisign.epp.codec.reseller.EPPResellerCreateResp;
import com.verisign.epp.codec.reseller.EPPResellerDeleteCmd;
import com.verisign.epp.codec.reseller.EPPResellerDisclose;
import com.verisign.epp.codec.reseller.EPPResellerInfoCmd;
import com.verisign.epp.codec.reseller.EPPResellerInfoResp;
import com.verisign.epp.codec.reseller.EPPResellerPostalDefinition;
import com.verisign.epp.codec.reseller.EPPResellerUpdateCmd;
import com.verisign.epp.codec.reseller.State;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EPPReseller {
    private EPPSession session = null;
    private String transId = null;
    private Vector extensions = null;
    private List<String> resellerIds = null;
    private State state = null;
    private String parentId = null;
    private List<EPPResellerPostalDefinition> postalInfo = null;
    private String voice = null;
    private String voiceExt = null;
    private String fax = null;
    private String faxExt = null;
    private String email = null;
    private String url = null;
    private List<EPPResellerContact> contacts = null;
    private List<EPPResellerContact> addContacts = null;
    private List<EPPResellerContact> remContacts = null;
    private EPPResellerDisclose disclose = null;

    public EPPReseller(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public List<String> getResellerIds() {
        return this.resellerIds;
    }

    public void addResellerId(String aResellerId) {
        if (this.resellerIds == null) {
            this.resellerIds = new ArrayList<String>();
        }
        this.resellerIds.add(aResellerId);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State aState) {
        this.state = aState;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPResellerPostalDefinition aPostalInfo) {
        if (this.postalInfo == null) {
            this.postalInfo = new ArrayList<EPPResellerPostalDefinition>();
        }
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPResellerPostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPResellerPostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public void addContact(EPPResellerContact aContact) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPResellerContact>();
        }
        this.contacts.add(aContact);
    }

    public List<EPPResellerContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPResellerContact> aContacts) {
        this.contacts = aContacts;
    }

    public void addAddContact(EPPResellerContact aContact) {
        if (this.addContacts == null) {
            this.addContacts = new ArrayList<EPPResellerContact>();
        }
        this.addContacts.add(aContact);
    }

    public List<EPPResellerContact> getAddContacts() {
        return this.addContacts;
    }

    public void setAddContacts(List<EPPResellerContact> aContacts) {
        this.addContacts = aContacts;
    }

    public boolean hasRemContacts() {
        return this.remContacts != null && !this.remContacts.isEmpty();
    }

    public void addRemContact(EPPResellerContact aContact) {
        if (this.remContacts == null) {
            this.remContacts = new ArrayList<EPPResellerContact>();
        }
        this.remContacts.add(aContact);
    }

    public List<EPPResellerContact> getRemContacts() {
        return this.remContacts;
    }

    public void setRemContacts(List<EPPResellerContact> aContacts) {
        this.remContacts = aContacts;
    }

    public EPPResellerDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPResellerDisclose aDisclose) {
        this.disclose = aDisclose;
    }

    public EPPResellerCheckResp sendCheck() throws EPPCommandException {
        if (this.resellerIds == null || this.resellerIds.isEmpty()) {
            throw new EPPCommandException("At least one reseller identifier is required for sendCheck()");
        }
        EPPResellerCheckCmd theCommand = new EPPResellerCheckCmd(this.transId);
        theCommand.setResellerIds(this.resellerIds);
        theCommand.setExtensions(this.extensions);
        this.resetReseller();
        return (EPPResellerCheckResp)this.session.processDocument(theCommand, EPPResellerCheckResp.class);
    }

    public EPPResellerInfoResp sendInfo() throws EPPCommandException {
        if (this.resellerIds == null || this.resellerIds.size() != 1) {
            throw new EPPCommandException("One reseller identifier is required for sendInfo()");
        }
        EPPResellerInfoCmd theCommand = new EPPResellerInfoCmd(this.transId);
        theCommand.setResellerId(this.resellerIds.get(0));
        theCommand.setExtensions(this.extensions);
        this.resetReseller();
        return (EPPResellerInfoResp)this.session.processDocument(theCommand, EPPResellerInfoResp.class);
    }

    public EPPResellerCreateResp sendCreate() throws EPPCommandException {
        if (this.resellerIds == null || this.resellerIds.isEmpty() || this.resellerIds.size() != 1) {
            throw new EPPCommandException("A reseller identifier is required for sendCreate()");
        }
        if (this.postalInfo == null || this.postalInfo.isEmpty() || this.postalInfo.size() > 2) {
            throw new EPPCommandException("A reseller postal information must have 1 or 2 items");
        }
        if (this.email == null) {
            throw new EPPCommandException("A reseller email is required");
        }
        EPPResellerCreateCmd theCommand = new EPPResellerCreateCmd(this.transId);
        theCommand.setResellerId(this.resellerIds.get(0));
        theCommand.setState(this.state);
        theCommand.setParentId(this.parentId);
        theCommand.setPostalInfo(this.postalInfo);
        theCommand.setVoice(this.voice);
        if (this.voice != null) {
            theCommand.setVoiceExt(this.voiceExt);
        }
        theCommand.setFax(this.fax);
        if (this.fax != null) {
            theCommand.setFaxExt(this.faxExt);
        }
        theCommand.setEmail(this.email);
        theCommand.setUrl(this.url);
        theCommand.setContacts(this.contacts);
        theCommand.setDisclose(this.disclose);
        theCommand.setExtensions(this.extensions);
        this.resetReseller();
        return (EPPResellerCreateResp)this.session.processDocument(theCommand, EPPResellerCreateResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.resellerIds == null || this.resellerIds.size() != 1) {
            throw new EPPCommandException("One reseller identifier is required for sendDelete()");
        }
        EPPResellerDeleteCmd theCommand = new EPPResellerDeleteCmd(this.transId);
        theCommand.setResellerId(this.resellerIds.get(0));
        theCommand.setExtensions(this.extensions);
        this.resetReseller();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.resellerIds == null || this.resellerIds.isEmpty() || this.resellerIds.size() != 1) {
            throw new EPPCommandException("A reseller identifier is required for sendCreate()");
        }
        EPPResellerUpdateCmd theCommand = new EPPResellerUpdateCmd(this.transId);
        theCommand.setResellerId(this.resellerIds.get(0));
        theCommand.setState(this.state);
        theCommand.setParentId(this.parentId);
        theCommand.setPostalInfo(this.postalInfo);
        theCommand.setVoice(this.voice);
        if (this.voice != null) {
            theCommand.setVoiceExt(this.voiceExt);
        }
        theCommand.setFax(this.fax);
        if (this.fax != null) {
            theCommand.setFaxExt(this.faxExt);
        }
        theCommand.setEmail(this.email);
        theCommand.setUrl(this.url);
        theCommand.setAddContacts(this.addContacts);
        theCommand.setRemContacts(this.remContacts);
        theCommand.setDisclose(this.disclose);
        theCommand.setExtensions(this.extensions);
        this.resetReseller();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    protected void resetReseller() {
        this.transId = null;
        this.extensions = null;
        this.resellerIds = null;
        this.state = null;
        this.parentId = null;
        this.postalInfo = null;
        this.voice = null;
        this.voiceExt = null;
        this.fax = null;
        this.faxExt = null;
        this.email = null;
        this.url = null;
        this.contacts = null;
        this.addContacts = null;
        this.remContacts = null;
        this.disclose = null;
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }
}

