/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.registry.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.EPPRegistryContact;
import com.verisign.epp.codec.registry.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.EPPRegistryDomain;
import com.verisign.epp.codec.registry.EPPRegistryFields;
import com.verisign.epp.codec.registry.EPPRegistryHost;
import com.verisign.epp.codec.registry.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.EPPRegistryPhase;
import com.verisign.epp.codec.registry.EPPRegistryRelated;
import com.verisign.epp.codec.registry.EPPRegistryServices;
import com.verisign.epp.codec.registry.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.EPPRegistryZone;
import com.verisign.epp.codec.registry.EPPRegistryZoneInfo;
import com.verisign.epp.codec.registry.EPPRegistryZoneMember;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPRegistry;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPRegistryTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPRegistryTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPRegistry registry = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new SecureRandom();

    public EPPRegistryTst(String name) {
        super(name);
    }

    public void testRegistry() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            try {
                numIterations = Integer.parseInt(iterationsStr);
                numIterations = numIterations < 1 ? 1 : numIterations;
            }
            catch (Exception e) {
                numIterations = 1;
            }
        }
        this.printStart("Test Suite");
        this.registryCreate("com", true);
        this.registryCreate("newtld1", true);
        this.registryCreate("newtld1", false);
        this.registryCreate("newtld2", true);
        this.registryCreate("newtld3", true);
        this.registryUpdate("newtld1", true);
        this.registryUpdate("newtld1", true);
        this.registryUpdate("newtld2", true);
        this.registryUpdate("newtld3", true);
        this.registryUpdate("newtld4", false);
        HashMap<String, Boolean> tldAvails = new HashMap<String, Boolean>();
        tldAvails.put("newtld1", Boolean.FALSE);
        tldAvails.put("newtld2", Boolean.FALSE);
        tldAvails.put("newtld3", Boolean.FALSE);
        tldAvails.put("newtld4", Boolean.TRUE);
        this.registryCheck(tldAvails);
        this.registryInfo(null);
        this.registryInfo("newtld2");
        this.registryInfo("com");
        this.registryDelete("newtld1", true);
        this.registryDelete("newtld1", false);
        this.registryDelete("newtld10", false);
        this.printEnd("Test Suite");
    }

    public void registryCheck(Map tldNames) {
        this.printStart("registryCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.print("registryCheck:");
            this.registry.resetRegistry();
            this.registry.setTransId("ABC-12345-XYZ");
            Iterator it = tldNames.entrySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next().getKey();
                System.out.print(" " + name + " ");
                this.registry.addTld(name);
            }
            System.out.println("");
            EPPRegistryCheckResp response = this.registry.sendCheck();
            System.out.println("registryCheck: Response = [" + response + "]\n\n");
            block3: for (Map.Entry entry : tldNames.entrySet()) {
                String name = (String)entry.getKey();
                Boolean available = (Boolean)entry.getValue();
                for (EPPRegistryCheckResult result : response.getCheckResults()) {
                    if (!result.getName().equals(name)) continue;
                    if (result.isAvailable().booleanValue() == available.booleanValue()) continue block3;
                    EPPRegistryTst.fail((String)("Expected availability for tld \"" + name + "\": " + available + ", but got: " + result.isAvailable()));
                }
            }
            EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("registryCheck");
    }

    public void registryCreate(String tldName, boolean shouldSucceed) {
        block4: {
            this.printStart("registryCreate");
            EPPRegistryCreateResp response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryCreate: " + tldName);
                this.registry.resetRegistry();
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.addTld(tldName);
                this.registry.setAuthString("ClientX");
                response = this.registry.sendCreate();
                System.out.println("registryCreate: Response = [" + response + "]\n\n");
                if (shouldSucceed) {
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!shouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryCreate");
    }

    public void registryDelete(String tldName, boolean shouldSucceed) {
        block4: {
            this.printStart("registryDelete");
            EPPResponse response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryDelete: " + tldName);
                this.registry.resetRegistry();
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.addTld(tldName);
                this.registry.setAuthString("ClientX");
                response = this.registry.sendDelete();
                System.out.println("registryDelete: Response = [" + response + "]\n\n");
                if (shouldSucceed) {
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!shouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryDelete");
    }

    public void registryUpdate(String tldName, boolean shouldSucceed) {
        block4: {
            this.printStart("registryUpdate");
            EPPResponse response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryUpdate: " + tldName);
                this.registry.resetRegistry();
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.addTld(tldName);
                this.registry.setAuthString("ClientX");
                response = this.registry.sendUpdate();
                System.out.println("registryUpdate: Response = [" + response + "]\n\n");
                if (shouldSucceed) {
                    EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!shouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryUpdate");
    }

    public void registryInfo(String tldName) {
        this.printStart("registryInfo");
        boolean all = false;
        if (tldName == null || tldName.trim().length() == 0) {
            all = true;
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            if (all) {
                System.out.println("registryInfo: all tlds");
            } else {
                System.out.println("registryInfo: single tld");
            }
            this.registry.setTransId("ABC-12345-XYZ");
            if (all) {
                this.registry.setAllTlds(true);
            } else {
                System.out.println("\nregistryInfo: " + tldName);
                this.registry.addTld(tldName);
            }
            EPPRegistryInfoResp response = this.registry.sendInfo();
            System.out.println("registryInfo: Response = [" + response + "]\n\n");
            if (all) {
                EPPRegistryTst.assertTrue((response.getZoneList() != null && response.getZoneList().getZoneList() != null && response.getZoneInfo() == null && response.getZoneList().getZoneList().size() > 0 ? 1 : 0) != 0);
                System.out.println("All TLDs: ");
                for (EPPRegistryZone tld : response.getZoneList().getZoneList()) {
                    EPPRegistryTst.assertTrue((tld.getName() != null && tld.getName().length() > 0 ? 1 : 0) != 0);
                    EPPRegistryTst.assertTrue((tld.getCreateDate() != null ? 1 : 0) != 0);
                    System.out.print(tld.getName() + "\tcreated on " + tld.getCreateDate());
                    if (tld.getUpdateDate() != null) {
                        System.out.println("\tupdated on " + tld.getUpdateDate());
                        continue;
                    }
                    System.out.println();
                }
            } else {
                EPPRegistryTst.assertTrue((response.getZoneList() == null && response.getZoneInfo() != null ? 1 : 0) != 0);
                EPPRegistryZoneInfo info = response.getZoneInfo();
                System.out.println("Zone name: " + info.getName());
                if (info.hasRelated()) {
                    System.out.println("Related zones: ");
                    EPPRegistryRelated related = info.getRelated();
                    if (related.hasFields()) {
                        EPPRegistryFields fields = related.getFields();
                        System.out.println("\ttype:" + fields.getType());
                        Iterator<String> it = fields.getFields().iterator();
                        while (it.hasNext()) {
                            System.out.println("\tfield: " + it.next());
                        }
                    }
                    System.out.println("\tMembers:");
                    for (EPPRegistryZoneMember member : info.getRelated().getMembers()) {
                        System.out.println("\t\tname: " + member.getZoneName() + ", type: " + member.getType());
                    }
                }
                if (info.getPhases() != null) {
                    System.out.println("Phases:");
                    for (EPPRegistryPhase phase : info.getPhases()) {
                        System.out.println("\ttype: " + phase.getType() + ", start: " + phase.getStartDate() + ", end: " + phase.getEndDate());
                    }
                }
                if (info.getServices() != null) {
                    System.out.println("Services:");
                    for (EPPRegistryServices.EPPRegistryObjURI objUri : info.getServices().getObjURIs()) {
                        System.out.println("\tobjURI: " + objUri.getUri() + ", required: " + objUri.getRequired());
                    }
                }
                if (info.getServices() != null && info.getServices().getExtension() != null) {
                    System.out.println("Services extension:");
                    for (EPPRegistryServicesExt.EPPRegistryExtURI extUri : info.getServices().getExtension().getExtURIs()) {
                        System.out.println("\textURI: " + extUri.getUri() + ", required: " + extUri.getRequired());
                    }
                }
                System.out.println("crId: " + info.getCreatedBy());
                System.out.println("crDate: " + info.getCreatedDate());
                System.out.println("upId: " + info.getLastUpdatedBy());
                System.out.println("upDate: " + info.getLastUpdatedDate());
                EPPRegistryDomain domain = info.getDomain();
                EPPRegistryTst.assertTrue((domain != null ? 1 : 0) != 0);
                System.out.println("Domain: " + domain);
                EPPRegistryHost host = info.getHost();
                EPPRegistryTst.assertTrue((host != null ? 1 : 0) != 0);
                EPPRegistryContact contact = info.getContact();
                EPPRegistryTst.assertTrue((contact != null ? 1 : 0) != 0);
            }
            EPPRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
            this.printEnd("registryInfo");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }

    public String makeTldName() {
        int len = this.rd.nextInt(15);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(97 + this.rd.nextInt(26));
        }
        return sb.toString();
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPRegistryTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.registry = new EPPRegistry(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }
}

