/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.nv.EPPDomainNameVerification;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResp;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResp;
import com.verisign.epp.codec.nv.EPPNameVerificationUpdateCmd;
import com.verisign.epp.codec.nv.EPPRealNameVerification;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EPPNameVerification {
    private EPPSession session = null;
    private String transId = null;
    private Vector extensions = null;
    EPPDomainNameVerification dnv;
    EPPRealNameVerification rnv;
    private List<String> labels = new ArrayList<String>();
    private String code;
    private EPPNameVerificationInfoCmd.Type infoType;
    private EPPAuthInfo authInfo;

    public EPPNameVerification(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public void addLabel(String aLabel) {
        this.labels.add(aLabel);
    }

    public void setAuthInfo(String aAuthInfo) {
        this.authInfo = new EPPAuthInfo(aAuthInfo);
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public void setDnv(EPPDomainNameVerification aDnv) {
        this.dnv = aDnv;
    }

    public void setRnv(EPPRealNameVerification aRnv) {
        this.rnv = aRnv;
    }

    public void setInfoType(EPPNameVerificationInfoCmd.Type aInfoType) {
        this.infoType = aInfoType;
    }

    public EPPNameVerificationCheckResp sendCheck() throws EPPCommandException {
        if (this.labels == null || this.labels.isEmpty()) {
            throw new EPPCommandException("At least one label must be set for sendCheck()");
        }
        EPPNameVerificationCheckCmd theCommand = new EPPNameVerificationCheckCmd(this.transId, this.labels);
        theCommand.setExtensions(this.extensions);
        this.resetNameVerification();
        return (EPPNameVerificationCheckResp)this.session.processDocument(theCommand, EPPNameVerificationCheckResp.class);
    }

    public EPPNameVerificationInfoResp sendInfo() throws EPPCommandException {
        if (this.code == null) {
            throw new EPPCommandException("Code must be set for sendInfo()");
        }
        if (this.infoType == null) {
            throw new EPPCommandException("infoType must be set for sendInfo()");
        }
        EPPNameVerificationInfoCmd theCommand = new EPPNameVerificationInfoCmd(this.transId);
        theCommand.setCode(this.code);
        theCommand.setInfoType(this.infoType);
        if (this.authInfo != null) {
            theCommand.setAuthInfo(new EPPAuthInfo(this.authInfo));
        }
        theCommand.setExtensions(this.extensions);
        this.resetNameVerification();
        return (EPPNameVerificationInfoResp)this.session.processDocument(theCommand, EPPNameVerificationInfoResp.class);
    }

    public EPPNameVerificationCreateResp sendCreate() throws EPPCommandException {
        if (this.dnv != null && this.rnv != null) {
            throw new EPPCommandException("DNV or RNV both set on sendCreate()");
        }
        if (this.dnv == null && this.rnv == null) {
            throw new EPPCommandException("DNV or RNV must be set on sendCreate()");
        }
        if (this.authInfo == null) {
            throw new EPPCommandException("Auth Info must be set on sendCreate()");
        }
        EPPNameVerificationCreateCmd theCommand = this.dnv != null ? new EPPNameVerificationCreateCmd(this.transId, this.dnv, this.authInfo) : new EPPNameVerificationCreateCmd(this.transId, this.rnv, this.authInfo);
        theCommand.setExtensions(this.extensions);
        this.resetNameVerification();
        return (EPPNameVerificationCreateResp)this.session.processDocument(theCommand, EPPNameVerificationCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.code == null) {
            throw new EPPCommandException("code must be set for sendUpdate()");
        }
        if (this.authInfo == null) {
            throw new EPPCommandException("authInfo must be set for sendUpdate()");
        }
        EPPNameVerificationUpdateCmd theCommand = new EPPNameVerificationUpdateCmd(this.transId, this.code, this.authInfo);
        theCommand.setExtensions(this.extensions);
        this.resetNameVerification();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    protected void resetNameVerification() {
        this.code = null;
        this.labels = new ArrayList<String>();
        this.authInfo = null;
        this.dnv = null;
        this.rnv = null;
        this.infoType = null;
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }
}

