/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.launch.EPPLaunchCheck;
import com.verisign.epp.codec.launch.EPPLaunchChkData;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Vector;

public class EPPLaunch {
    public static final String PHASE_SUNRISE = "sunrise";
    public static final String PHASE_LANDRUSH = "landrush";
    public static final String PHASE_CLAIMS = "claims";
    public static final String PHASE_OPEN = "open";
    public static final String PHASE_CUSTOM = "custom";
    public static final String TYPE_CLAIMS = "claims";
    public static final String TYPE_AVAILABILITY = "avail";
    private Vector domainList = new Vector();
    private EPPSession session = null;
    private String transId = null;
    private Vector extensions = null;
    private String phase = "claims";
    private String phaseName;
    private String type;

    public EPPLaunch(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void addDomainName(String aDomain) {
        this.domainList.addElement(aDomain);
    }

    public EPPResponse sendCheck() throws EPPCommandException {
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd(this.transId, this.domainList);
        EPPLaunchPhase thePhase = this.phaseName != null ? new EPPLaunchPhase(this.phase, this.phaseName) : new EPPLaunchPhase(this.phase);
        EPPLaunchCheck theExt = new EPPLaunchCheck(thePhase);
        if (this.type != null) {
            theExt.setType(this.type);
        }
        this.addExtension(theExt);
        theCommand.setExtensions(this.extensions);
        this.resetLaunch();
        EPPResponse theResponse = this.session.processDocument(theCommand, EPPResponse.class);
        if (!(theResponse instanceof EPPResponse && !theResponse.hasExtension(EPPLaunchChkData.class.getClass()) || theResponse instanceof EPPDomainCheckResp)) {
            throw new EPPCommandException("Unexpected response type of " + theResponse.getClass().getName() + ", expecting either " + EPPResponse.class.getName() + " with " + EPPLaunchChkData.class.getName() + " extension or " + EPPDomainCheckResp.class.getName());
        }
        return theResponse;
    }

    protected void resetLaunch() {
        this.domainList = new Vector();
        this.transId = null;
        this.extensions = null;
        this.phase = "claims";
        this.phaseName = null;
        this.type = null;
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public void setPhase(String aPhase) {
        this.phase = aPhase;
    }

    public void setPhaseName(String aPhaseName) {
        this.phaseName = aPhaseName;
    }

    public void setType(String aType) {
        this.type = aType;
    }
}

