/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckCmd;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckResp;
import com.verisign.epp.codec.idntable.EPPIdnTableDomainLabel;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoCmd;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoResp;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EPPIdnTable {
    private EPPSession session = null;
    private String transId = null;
    private Vector extensions = null;
    private List<EPPIdnTableDomainLabel> domains = new ArrayList<EPPIdnTableDomainLabel>();
    private List<String> tables = new ArrayList<String>();

    public EPPIdnTable(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public void addDomain(String aDomain, EPPIdnTableDomainLabel.Form aForm) {
        this.domains.add(new EPPIdnTableDomainLabel(aDomain, aForm));
    }

    public void addTable(String aTable) {
        this.tables.add(aTable);
    }

    public EPPIdnTableCheckResp sendDomainCheck() throws EPPCommandException {
        if (this.domains.isEmpty()) {
            throw new EPPCommandException("At least one domain is required for sendDomainCheck()");
        }
        EPPIdnTableCheckCmd theCommand = new EPPIdnTableCheckCmd(this.transId);
        theCommand.setDomains(this.domains);
        theCommand.setExtensions(this.extensions);
        this.resetIdnTable();
        return (EPPIdnTableCheckResp)this.session.processDocument(theCommand, EPPIdnTableCheckResp.class);
    }

    public EPPIdnTableCheckResp sendTableCheck() throws EPPCommandException {
        if (this.tables.isEmpty()) {
            throw new EPPCommandException("At least one table is required for sendTableCheck()");
        }
        EPPIdnTableCheckCmd theCommand = new EPPIdnTableCheckCmd(this.transId);
        theCommand.setTables(this.tables);
        theCommand.setExtensions(this.extensions);
        this.resetIdnTable();
        return (EPPIdnTableCheckResp)this.session.processDocument(theCommand, EPPIdnTableCheckResp.class);
    }

    public EPPIdnTableInfoResp sendDomainInfo() throws EPPCommandException {
        if (this.domains.size() != 1) {
            throw new EPPCommandException("One domain is required for sendDomainInfo()");
        }
        EPPIdnTableInfoCmd theCommand = new EPPIdnTableInfoCmd(this.transId);
        theCommand.setForm(EPPIdnTableInfoCmd.Form.DOMAIN_FORM);
        theCommand.setDomain(this.domains.get(0).getDomain());
        theCommand.setExtensions(this.extensions);
        this.resetIdnTable();
        return (EPPIdnTableInfoResp)this.session.processDocument(theCommand, EPPIdnTableInfoResp.class);
    }

    public EPPIdnTableInfoResp sendTableInfo() throws EPPCommandException {
        if (this.tables.size() != 1) {
            throw new EPPCommandException("One table is required for sendTableInfo()");
        }
        EPPIdnTableInfoCmd theCommand = new EPPIdnTableInfoCmd(this.transId);
        theCommand.setForm(EPPIdnTableInfoCmd.Form.TABLE_FORM);
        theCommand.setTable(this.tables.get(0));
        theCommand.setExtensions(this.extensions);
        this.resetIdnTable();
        return (EPPIdnTableInfoResp)this.session.processDocument(theCommand, EPPIdnTableInfoResp.class);
    }

    public EPPIdnTableInfoResp sendListInfo() throws EPPCommandException {
        EPPIdnTableInfoCmd theCommand = new EPPIdnTableInfoCmd(this.transId);
        theCommand.setForm(EPPIdnTableInfoCmd.Form.LIST_FORM);
        theCommand.setExtensions(this.extensions);
        this.resetIdnTable();
        return (EPPIdnTableInfoResp)this.session.processDocument(theCommand, EPPIdnTableInfoResp.class);
    }

    protected void resetIdnTable() {
        this.domains = new ArrayList<EPPIdnTableDomainLabel>();
        this.tables = new ArrayList<String>();
        this.transId = null;
        this.extensions = null;
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }
}

