/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Date;
import java.util.Vector;

public class EPPDomain {
    public static final int HOST = 0;
    public static final int CONTACT = 1;
    public static final int STATUS = 2;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int CHANGE = 3;
    public static final String STATUS_OK = "ok";
    public static final String STATUS_SERVER_HOLD = "serverHold";
    public static final String STATUS_SERVER_RENEW_PROHIBITED = "serverRenewProhibited";
    public static final String STATUS_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String STATUS_INACTIVE = "inactive";
    public static final String STATUS_PENDING_CREATE = "pendingCreate";
    public static final String STATUS_PENDING_DELETE = "pendingDelete";
    public static final String STATUS_PENDING_RENEW = "pendingRenew";
    public static final String STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String STATUS_PENDING_UPDATE = "pendingUpdate";
    public static final String STATUS_CLIENT_HOLD = "clientHold";
    public static final String STATUS_CLIENT_RENEW_PROHIBITED = "clientRenewProhibited";
    public static final String STATUS_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String TRANSFER_APPROVE = "approve";
    public static final String TRANSFER_CANCEL = "cancel";
    public static final String TRANSFER_QUERY = "query";
    public static final String TRANSFER_REJECT = "reject";
    public static final String TRANSFER_REQUEST = "request";
    public static final String CONTACT_ADMINISTRATIVE = "admin";
    public static final String CONTACT_BILLING = "billing";
    public static final String CONTACT_TECHNICAL = "tech";
    public static final String PERIOD_MONTH = "m";
    public static final String PERIOD_YEAR = "y";
    public static final String HOSTS_ALL = "all";
    public static final String HOSTS_DELEGATED = "del";
    public static final String HOSTS_SUBORDINATE = "sub";
    private Vector domainList = new Vector();
    private Vector hostList = new Vector();
    private Vector contactList = new Vector();
    private Vector updateAttribs = new Vector();
    private EPPSession session = null;
    private String transId = null;
    private Date expirationDate;
    private String transferOpCode;
    private int periodLength = 1;
    private String periodUnit;
    private String authString;
    private String authRoid;
    private Vector extensions = null;
    private String registrant = null;
    private String hosts = "all";

    public EPPDomain(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void addDomainName(String aDomain) {
        this.domainList.addElement(aDomain);
    }

    public void addHostName(String aHost) {
        this.hostList.addElement(aHost);
    }

    public void addHostAttr(EPPHostAttr aHostAttr) {
        this.hostList.addElement(aHostAttr);
    }

    public void addContact(String aName, String aType) {
        this.contactList.addElement(new EPPDomainContact(aName, aType));
    }

    public void setExpirationDate(Date aExpirationDate) {
        this.expirationDate = aExpirationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setTransferOpCode(String aTransferOpCode) {
        this.transferOpCode = aTransferOpCode;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public void setAuthString(String aAuthString) {
        this.authString = aAuthString;
    }

    public String getAuthRoid() {
        return this.authRoid;
    }

    public void setAuthRoid(String aAuthRoid) {
        this.authRoid = aAuthRoid;
    }

    public String getAuthString() {
        return this.authString;
    }

    public void setHosts(String aHosts) {
        this.hosts = aHosts;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setRegistrant(String aRegistrant) {
        this.registrant = aRegistrant;
    }

    public EPPDomainCreateResp sendCreate() throws EPPCommandException {
        if (this.domainList.size() != 1) {
            throw new EPPCommandException("One Domain Name is required for sendCreate()");
        }
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            if (this.contactList.size() == 0) {
                this.contactList = null;
            }
        } else {
            this.contactList = null;
        }
        if (this.hostList.size() == 0) {
            this.hostList = null;
        }
        EPPDomainPeriod thePeriod = null;
        if (this.periodLength >= 0) {
            thePeriod = this.periodUnit != null ? new EPPDomainPeriod(this.periodUnit, this.periodLength) : new EPPDomainPeriod(this.periodLength);
        }
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd(this.transId, (String)this.domainList.firstElement(), this.hostList, this.contactList, thePeriod, new EPPAuthInfo(this.authString));
        if (this.registrant != null) {
            theCommand.setRegistrant(this.registrant);
        }
        theCommand.setExtensions(this.extensions);
        this.resetDomain();
        return (EPPDomainCreateResp)this.session.processDocument(theCommand, EPPDomainCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.domainList.size() != 1) {
            throw new EPPCommandException("One Domain Name is required for sendUpdate()");
        }
        Vector hostUpdate = null;
        Vector contactUpdate = null;
        Vector statusUpdate = null;
        hostUpdate = this.getUpdateAttribCnt(0, 1) == 0 ? null : this.getUpdateAttribVector(0, 1);
        contactUpdate = this.getUpdateAttribCnt(1, 1) == 0 ? null : this.getUpdateAttribVector(1, 1);
        statusUpdate = this.getUpdateAttribCnt(2, 1) == 0 ? null : this.getUpdateAttribVector(2, 1);
        EPPDomainAddRemove addItems = null;
        if (hostUpdate != null || contactUpdate != null || statusUpdate != null) {
            addItems = new EPPDomainAddRemove(hostUpdate, contactUpdate, statusUpdate);
        }
        hostUpdate = this.getUpdateAttribCnt(0, 2) == 0 ? null : this.getUpdateAttribVector(0, 2);
        contactUpdate = this.getUpdateAttribCnt(1, 2) == 0 ? null : this.getUpdateAttribVector(1, 2);
        statusUpdate = this.getUpdateAttribCnt(2, 2) == 0 ? null : this.getUpdateAttribVector(2, 2);
        EPPDomainAddRemove removeItems = null;
        if (hostUpdate != null || contactUpdate != null || statusUpdate != null) {
            removeItems = new EPPDomainAddRemove(hostUpdate, contactUpdate, statusUpdate);
        }
        EPPDomainAddRemove changeItems = null;
        if (this.registrant != null || this.authString != null) {
            changeItems = new EPPDomainAddRemove();
            if (this.registrant != null) {
                changeItems.setRegistrant(this.registrant);
            }
            if (this.authString != null) {
                changeItems.setAuthInfo(new EPPAuthInfo(this.authString));
            }
        }
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd(this.transId, (String)this.domainList.firstElement(), addItems, removeItems, changeItems);
        theCommand.setExtensions(this.extensions);
        this.resetDomain();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPDomainTransferResp sendTransfer() throws EPPCommandException {
        if (this.domainList.size() != 1) {
            throw new EPPCommandException("One Domain Name is required for sendTransfer()");
        }
        if (this.transferOpCode == null) {
            throw new EPPCommandException("Transfer Operation Code is required.");
        }
        EPPDomainTransferCmd theCommand = new EPPDomainTransferCmd(this.transId, this.transferOpCode, (String)this.domainList.firstElement());
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            theCommand.setAuthInfo(theAuthInfo);
        }
        if (this.transferOpCode.equals(TRANSFER_REQUEST)) {
            EPPDomainPeriod thePeriod = null;
            thePeriod = this.periodLength < 0 ? null : (this.periodUnit == null ? new EPPDomainPeriod(this.periodLength) : new EPPDomainPeriod(this.periodUnit, this.periodLength));
            theCommand.setPeriod(thePeriod);
        }
        theCommand.setExtensions(this.extensions);
        this.resetDomain();
        return (EPPDomainTransferResp)this.session.processDocument(theCommand, EPPDomainTransferResp.class);
    }

    public EPPDomainRenewResp sendRenew() throws EPPCommandException {
        if (this.domainList.size() != 1) {
            throw new EPPCommandException("One Domain Name is required for sendCreate()");
        }
        EPPDomainPeriod thePeriod = null;
        if (this.periodLength >= 0) {
            thePeriod = this.periodUnit != null ? new EPPDomainPeriod(this.periodUnit, this.periodLength) : new EPPDomainPeriod(this.periodLength);
        }
        EPPDomainRenewCmd theCommand = new EPPDomainRenewCmd(this.transId, (String)this.domainList.firstElement(), this.expirationDate, thePeriod);
        theCommand.setExtensions(this.extensions);
        this.resetDomain();
        return (EPPDomainRenewResp)this.session.processDocument(theCommand, EPPDomainRenewResp.class);
    }

    public EPPDomainInfoResp sendInfo() throws EPPCommandException {
        if (this.domainList.size() != 1) {
            throw new EPPCommandException("One Domain Name is required for sendInfo()");
        }
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd(this.transId, (String)this.domainList.firstElement());
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            theCommand.setAuthInfo(theAuthInfo);
        }
        theCommand.setHosts(this.hosts);
        theCommand.setExtensions(this.extensions);
        this.resetDomain();
        return (EPPDomainInfoResp)this.session.processDocument(theCommand, EPPDomainInfoResp.class);
    }

    public EPPDomainCheckResp sendCheck() throws EPPCommandException {
        Object myDoc = null;
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd(this.transId, this.domainList);
        theCommand.setExtensions(this.extensions);
        this.resetDomain();
        return (EPPDomainCheckResp)this.session.processDocument(theCommand, EPPDomainCheckResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.domainList.size() != 1) {
            throw new EPPCommandException("One Domain Name is required for sendDelete()");
        }
        EPPDomainDeleteCmd theCommand = new EPPDomainDeleteCmd(this.transId, (String)this.domainList.firstElement());
        theCommand.setExtensions(this.extensions);
        this.resetDomain();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    protected void resetDomain() {
        this.domainList = new Vector();
        this.hostList = new Vector();
        this.contactList = new Vector();
        this.updateAttribs = new Vector();
        this.transId = null;
        this.expirationDate = null;
        this.transferOpCode = null;
        this.periodLength = 1;
        this.periodUnit = null;
        this.authString = null;
        this.authRoid = null;
        this.extensions = null;
        this.registrant = null;
        this.hosts = HOSTS_ALL;
    }

    public void setUpdateAttrib(int aType, String aName, int aOp) throws EPPCommandException {
        if (aType != 0) {
            throw new EPPCommandException("setUpdateAttrib(int, String, int): " + aType + " is an invalid type");
        }
        if (aOp == 3) {
            throw new EPPCommandException("setUpdateAttrib(int, String, int): CHANGE is an invalid operation");
        }
        this.updateAttribs.addElement(new UpdateAttrib(aType, aName, aOp));
    }

    public void setUpdateAttrib(int aType, EPPDomainStatus aName, int aOp) throws EPPCommandException {
        if (aType != 2) {
            throw new EPPCommandException("setUpdateAttrib(int, EPPDomainStatus, int): " + aType + " is an invalid type");
        }
        if (aOp == 3) {
            throw new EPPCommandException("setUpdateAttrib(int, EPPDomainStatus, int): CHANGE is an invalid operation");
        }
        this.updateAttribs.addElement(new UpdateAttrib(aType, aName, aOp));
    }

    public void setUpdateAttrib(int aType, String aVal, String aValType, int aOp) throws EPPCommandException {
        if (aType != 1) {
            throw new EPPCommandException("setUpdateAttrib(int, String, String, int): " + aType + " is an invalid type");
        }
        if (aOp == 3) {
            throw new EPPCommandException("setUpdateAttrib(int, String, String, int): CHANGE is an invalid operation");
        }
        this.updateAttribs.addElement(new UpdateAttrib(aType, new EPPDomainContact(aVal, aValType), aOp));
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }

    public int getPeriodLength() {
        return this.periodLength;
    }

    public void setPeriodLength(int aPeriodLength) {
        this.periodLength = aPeriodLength;
    }

    public String getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(String aPeriodUnit) {
        this.periodUnit = aPeriodUnit;
    }

    private int getUpdateAttribCnt(int aType, int aOp) {
        int cnt = 0;
        for (int i = 0; i < this.updateAttribs.size(); ++i) {
            UpdateAttrib currAttrib = (UpdateAttrib)this.updateAttribs.elementAt(i);
            if (!currAttrib.getType(aType, aOp)) continue;
            ++cnt;
        }
        return cnt;
    }

    private Vector getUpdateAttribVector(int aType, int aOp) {
        int cnt = this.getUpdateAttribCnt(aType, aOp);
        if (cnt == 0) {
            return null;
        }
        Vector<Object> theAttribs = new Vector<Object>(cnt);
        for (int i = 0; i < this.updateAttribs.size(); ++i) {
            UpdateAttrib currAttr = (UpdateAttrib)this.updateAttribs.elementAt(i);
            if (!currAttr.getType(aType, aOp)) continue;
            theAttribs.addElement(currAttr.getVal());
        }
        return theAttribs;
    }

    private static class UpdateAttrib {
        private int type = 0;
        private Object val = null;
        private int op = 0;

        public UpdateAttrib(int aType, Object aVal, int aOp) throws EPPCommandException {
            if (aType != 0 && aType != 1 && aType != 2) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Type of " + aType);
            }
            if (aOp != 1 && aOp != 2 && aOp != 3) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Operation of " + aOp);
            }
            if (aVal == null) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Value (null)");
            }
            this.type = aType;
            this.val = aVal;
            this.op = aOp;
        }

        public boolean getType(int aType, int aOp) {
            return aType == this.type && aOp == this.op;
        }

        public Object getVal() {
            return this.val;
        }
    }
}

