/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.whowas;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPWhoWasInfoCmd
extends EPPInfoCmd {
    static final String ELM_NAME = "whowas:info";
    private String whowasType = "domain";
    private String name = null;
    private String roid = null;
    private static Logger cat = Logger.getLogger((String)EPPWhoWasInfoCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPWhoWasInfoCmd() {
    }

    public EPPWhoWasInfoCmd(String aTransId) {
        super(aTransId);
    }

    public EPPWhoWasInfoCmd(String aTransId, String aWhoWasType) {
        super(aTransId);
        this.whowasType = aWhoWasType;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            if (!super.equals(o)) {
                cat.error((Object)"EPPWhoWasInfoCmd.equals(): super class not equal");
                return false;
            }
            EPPWhoWasInfoCmd other = (EPPWhoWasInfoCmd)o;
            if (!EqualityUtil.equals(this.whowasType, other.whowasType)) {
                cat.error((Object)"EPPWhoWasInfoCmd.equals(): type not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.name, other.name)) {
                cat.error((Object)"EPPWhoWasInfoCmd.equals(): name not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.roid, other.roid)) {
                cat.error((Object)"EPPWhoWasInfoCmd.equals(): roid not equal");
                return false;
            }
            return true;
        }
        cat.error((Object)"EPPWhoWasInfoCmd.equals(): not EPPWhoWasInfoCmd instance");
        return false;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/whowas-1.0";
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.whowasType = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:type");
        if (this.whowasType == null) {
            throw new EPPDecodeException("Expected type element");
        }
        this.name = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:name");
        this.roid = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whowas-1.0", "whowas:roid");
        if (this.name == null && this.roid == null) {
            throw new EPPDecodeException("Expected one of the name or roid elements");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.whowasType == null) {
            throw new EPPEncodeException("EPPWhoWasInfoCmd type attribute must be set.");
        }
        if (this.name == null && this.roid == null) {
            throw new EPPEncodeException("EPPWhoWasInfoCmd name or roid attributes must be set");
        }
        if (this.name != null && this.roid != null) {
            throw new EPPEncodeException("EPPWhoWasInfoCmd both name and roid attributes must not be set");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/whowas-1.0", ELM_NAME);
        root.setAttribute("xmlns:whowas", "http://www.verisign.com/epp/whowas-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign.com/epp/whowas-1.0 whowas-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.whowasType, "http://www.verisign.com/epp/whowas-1.0", "whowas:type");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.verisign.com/epp/whowas-1.0", "whowas:name");
        EPPUtil.encodeString(aDocument, root, this.roid, "http://www.verisign.com/epp/whowas-1.0", "whowas:roid");
        return root;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public String getWhowasType() {
        return this.whowasType;
    }

    public void setWhowasType(String aWhowasType) {
        this.whowasType = aWhowasType;
    }
}

