/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPVerificationCode
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPVerificationCode.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "code";
    public static final String ELM_NAME = "verificationCode:code";
    public static int UNDEFINED = -1;
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SET_DATE = "date";
    private static final String ATTR_DUE_DATE = "due";
    private String code;
    private String type;
    private Date setDate;
    private Date dueDate;

    public EPPVerificationCode() {
    }

    public EPPVerificationCode(String aCode, String aType) {
        this.code = aCode;
        this.type = aType;
    }

    public EPPVerificationCode(String aType, Date aDueDate) {
        this.type = aType;
        this.dueDate = aDueDate;
    }

    public EPPVerificationCode(String aCode, String aType, Date aSetDate) {
        this.code = aCode;
        this.type = aType;
        this.setDate = aSetDate;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = aElement.getAttribute(ATTR_TYPE);
        this.setDate = aElement.getAttribute(ATTR_SET_DATE) != null && !aElement.getAttribute(ATTR_SET_DATE).isEmpty() ? EPPUtil.decodeTimeInstant(aElement.getAttribute(ATTR_SET_DATE)) : null;
        this.dueDate = aElement.getAttribute(ATTR_DUE_DATE) != null && !aElement.getAttribute(ATTR_DUE_DATE).isEmpty() ? EPPUtil.decodeTimeInstant(aElement.getAttribute(ATTR_DUE_DATE)) : null;
        this.code = EPPUtil.decodeStringValue(aElement);
        if (this.code.isEmpty()) {
            this.code = null;
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        cat.debug((Object)"EPPVerificationCode.encode(Document): enter");
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPVerificationCode.encode(Document)");
        }
        if (this.type == null) {
            throw new EPPEncodeException("Type is required.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:verificationCode-1.0", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.type);
        if (this.hasSetDate()) {
            root.setAttribute(ATTR_SET_DATE, EPPUtil.encodeTimeInstant(this.setDate));
        }
        if (this.hasDueDate()) {
            root.setAttribute(ATTR_DUE_DATE, EPPUtil.encodeTimeInstant(this.dueDate));
        }
        if (this.code != null) {
            Text codeVal = aDocument.createTextNode(this.code);
            root.appendChild(codeVal);
        }
        cat.debug((Object)"EPPVerificationCode.encode(Document): exit");
        return root;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPVerificationCode clone = (EPPVerificationCode)super.clone();
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPVerificationCode)) {
            cat.error((Object)"EPPVerificationCode.equals(): aObject is not an EPPVerificationCode");
            return false;
        }
        EPPVerificationCode other = (EPPVerificationCode)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error((Object)"EPPVerificationCode.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error((Object)"EPPVerificationCode.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.setDate, other.setDate)) {
            cat.error((Object)"EPPVerificationCode.equals(): setDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.dueDate, other.dueDate)) {
            cat.error((Object)"EPPVerificationCode.equals(): dueDate not equal");
            return false;
        }
        return true;
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public int getVspId() {
        int theVspId = UNDEFINED;
        if (!this.hasCode()) {
            return UNDEFINED;
        }
        String[] tokens = this.code.split("-");
        if (tokens.length != 2) {
            return UNDEFINED;
        }
        try {
            theVspId = Integer.parseInt(tokens[0]);
        }
        catch (Exception ex) {
            cat.debug((Object)("getVspId(): Exception on call to Integer.parseInt(" + tokens[0] + "): " + ex));
        }
        return theVspId;
    }

    public String getVerificationId() {
        if (!this.hasCode()) {
            return null;
        }
        String[] tokens = this.code.split("-");
        if (tokens.length != 2) {
            return null;
        }
        return tokens[1];
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public boolean hasSetDate() {
        return this.setDate != null;
    }

    public Date getSetDate() {
        return this.setDate;
    }

    public void setSetDate(Date aSetDate) {
        this.setDate = aSetDate;
    }

    public boolean hasDueDate() {
        return this.dueDate != null;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date aDueDate) {
        this.dueDate = aDueDate;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

