/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion.util;

import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import java.io.Serializable;

public class UnsignedLong
implements Serializable {
    private static final long serialVersionUID = -6046327834170745427L;
    public static long NONE = -1L;
    public static String NONE_STRING = "";
    protected long longValue = NONE;

    public UnsignedLong() {
    }

    public UnsignedLong(long aLongValue) throws InvalidValueException {
        this.set(aLongValue);
    }

    public UnsignedLong(String aLongAsString) throws InvalidValueException {
        this.set(aLongAsString);
    }

    public long get() {
        return this.longValue;
    }

    public boolean isSet() {
        return this.longValue != NONE;
    }

    public void set(long aLongValue) throws InvalidValueException {
        if (aLongValue < 0L) {
            throw new InvalidValueException(aLongValue);
        }
        this.longValue = aLongValue;
    }

    public void set(String aLongAsString) throws InvalidValueException {
        if (aLongAsString == null || aLongAsString.length() == 0) {
            this.longValue = NONE;
        } else {
            this.set(Long.parseLong(aLongAsString));
        }
    }

    public void unset() {
        this.longValue = NONE;
    }

    public UnsignedLong getRandom() {
        try {
            return new UnsignedLong((long)(Math.random() * 75.0 + 25.0));
        }
        catch (InvalidValueException x) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new UnsignedLong(this.longValue);
        }
        catch (InvalidValueException x) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            UnsignedLong other = (UnsignedLong)o;
            return this.longValue == other.longValue;
        }
        return false;
    }

    public String toString() {
        if (this.isSet()) {
            return "" + this.longValue;
        }
        return NONE_STRING;
    }
}

