/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.util.ExceptionUtil;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.codec.suggestion.util.WeightEnum;
import com.verisign.epp.util.EqualityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSuggestionAction
implements EPPCodecComponent {
    private static final long serialVersionUID = -2346800563494436852L;
    private static final String ATT_NAME = "name";
    private static final String ATT_WEIGHT = "weight";
    static final String ELM_NAME = "suggestion:action";
    private String name = null;
    private WeightEnum weight = new WeightEnum();

    public EPPSuggestionAction() {
    }

    public EPPSuggestionAction(Element aElement) throws EPPDecodeException {
        this.decode(aElement);
    }

    public EPPSuggestionAction(String aName, String aWeight) throws InvalidValueException {
        this();
        this.setName(aName);
        this.setWeight(aWeight);
    }

    public String getName() {
        return this.name;
    }

    public WeightEnum getWeight() {
        return this.weight;
    }

    public void setName(String aName) {
        this.name = aName != null ? aName.toLowerCase() : aName;
    }

    public void setWeight(String aWeight) throws InvalidValueException {
        this.weight.set(aWeight);
    }

    public String toLogString() {
        return this.name + ":" + this.weight;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setName(aElement.getAttribute(ATT_NAME));
        if (this.name == null) {
            ExceptionUtil.missingDuringDecode(ATT_NAME);
        }
        this.setWeight(aElement.getAttribute(ATT_WEIGHT));
        if (this.weight == null) {
            ExceptionUtil.missingDuringDecode(ATT_WEIGHT);
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.name == null) {
            ExceptionUtil.missingDuringEncode(ATT_NAME);
        }
        if (!this.weight.isSet()) {
            ExceptionUtil.missingDuringEncode(ATT_WEIGHT);
        }
        root.setAttribute(ATT_NAME, this.name);
        root.setAttribute(ATT_WEIGHT, this.weight.toString());
        return root;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionAction)super.clone();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionAction other = (EPPSuggestionAction)o;
            if (!EqualityUtil.equals(this.name, other.name)) {
                return false;
            }
            return this.weight.equals(other.weight);
        }
        return false;
    }
}

