/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secdnsext.v10;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtDsData;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSecDNSExtUpdate
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPSecDNSExtUpdate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "secDNS:update";
    public static final String ADD_ELM_NAME = "secDNS:add";
    public static final String CHG_ELM_NAME = "secDNS:chg";
    public static final String REM_ELM_NAME = "secDNS:rem";
    private static final String ATTR_URGENT = "urgent";
    private List addDsData = null;
    private List chgDsData = null;
    private List remKeyTag = null;
    private boolean urgent = false;

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:secDNS-1.0";
    }

    public EPPSecDNSExtUpdate() {
    }

    public EPPSecDNSExtUpdate(List addDsData, List chgDsData, List remKeyTag) {
        this.addDsData = addDsData;
        this.chgDsData = chgDsData;
        this.remKeyTag = remKeyTag;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPSecDNSExtUpdate.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPSecDNSExtUpdate invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPSecDNSExtUpdate.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.0", ELM_NAME);
        root.setAttribute("xmlns:secDNS", "urn:ietf:params:xml:ns:secDNS-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:secDNS-1.0 secDNS-1.0.xsd");
        if (this.addDsData != null) {
            Element add = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.0", ADD_ELM_NAME);
            EPPUtil.encodeCompList(aDocument, add, this.addDsData);
            root.appendChild(add);
        }
        if (this.chgDsData != null) {
            Element chg = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.0", CHG_ELM_NAME);
            EPPUtil.encodeCompList(aDocument, chg, this.chgDsData);
            root.appendChild(chg);
        }
        if (this.remKeyTag != null) {
            Element rem = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.0", REM_ELM_NAME);
            EPPUtil.encodeIntegerList(aDocument, rem, this.remKeyTag, "urn:ietf:params:xml:ns:secDNS-1.0", "secDNS:keyTag");
            root.appendChild(rem);
        }
        EPPUtil.encodeBooleanAttr(root, ATTR_URGENT, this.urgent);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element addElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ADD_ELM_NAME);
        this.addDsData = null;
        if (addElm != null) {
            this.addDsData = EPPUtil.decodeCompList(addElm, "urn:ietf:params:xml:ns:secDNS-1.0", "secDNS:dsData", EPPSecDNSExtDsData.class);
            if (this.addDsData != null && this.addDsData.size() == 0) {
                this.addDsData = null;
            }
        }
        Element chgElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", CHG_ELM_NAME);
        this.chgDsData = null;
        if (chgElm != null) {
            this.chgDsData = EPPUtil.decodeCompList(chgElm, "urn:ietf:params:xml:ns:secDNS-1.0", "secDNS:dsData", EPPSecDNSExtDsData.class);
            if (this.chgDsData != null && this.chgDsData.size() == 0) {
                this.chgDsData = null;
            }
        }
        Element remElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", REM_ELM_NAME);
        this.remKeyTag = null;
        if (remElm != null) {
            this.remKeyTag = EPPUtil.decodeIntegerList(remElm, "urn:ietf:params:xml:ns:secDNS-1.0", "secDNS:keyTag");
            if (this.remKeyTag != null && this.remKeyTag.size() == 0) {
                this.remKeyTag = null;
            }
        }
        this.urgent = EPPUtil.decodeBooleanAttr(aElement, ATTR_URGENT);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSecDNSExtUpdate)) {
            return false;
        }
        EPPSecDNSExtUpdate theComp = (EPPSecDNSExtUpdate)aObject;
        if (!EPPUtil.equalLists(this.addDsData, theComp.addDsData)) {
            cat.error((Object)"EPPSecDNSExtUpdate.equals(): addDsData not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.chgDsData, theComp.chgDsData)) {
            cat.error((Object)"EPPSecDNSExtUpdate.equals(): chgDsData not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.remKeyTag, theComp.remKeyTag)) {
            cat.error((Object)"EPPSecDNSExtUpdate.equals(): remKeyTag not equal");
            return false;
        }
        return !this.urgent != theComp.urgent;
    }

    void validateState() throws EPPCodecException {
        if (this.addDsData == null && this.chgDsData == null && this.remKeyTag == null) {
            throw new EPPCodecException("EPPSecDNSExtUpdate required attribute missing");
        }
        if (this.addDsData != null && (this.chgDsData != null || this.remKeyTag != null) || this.chgDsData != null && (this.addDsData != null || this.remKeyTag != null) || this.remKeyTag != null && (this.chgDsData != null || this.addDsData != null)) {
            throw new EPPCodecException("Only one add, chg, or rem is allowed");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSecDNSExtUpdate clone = null;
        clone = (EPPSecDNSExtUpdate)super.clone();
        if (this.addDsData != null) {
            clone.addDsData = new ArrayList(this.addDsData);
        }
        if (this.chgDsData != null) {
            clone.chgDsData = new ArrayList(this.chgDsData);
        }
        if (this.remKeyTag != null) {
            clone.remKeyTag = new ArrayList(this.remKeyTag);
        }
        clone.urgent = this.urgent;
        return clone;
    }

    public List getAdd() {
        return this.addDsData;
    }

    public void setAdd(List addDsData) {
        this.addDsData = addDsData;
    }

    public void appendAdd(EPPSecDNSExtDsData dsData) {
        if (this.addDsData == null) {
            this.addDsData = new ArrayList();
        }
        this.addDsData.add(dsData);
    }

    public List getChg() {
        return this.chgDsData;
    }

    public void setChg(List chgDsData) {
        this.chgDsData = chgDsData;
    }

    public void appendChg(EPPSecDNSExtDsData dsData) {
        if (this.chgDsData == null) {
            this.chgDsData = new ArrayList();
        }
        this.chgDsData.add(dsData);
    }

    public List getRem() {
        return this.remKeyTag;
    }

    public void setRem(List remKeyTag) {
        this.remKeyTag = remKeyTag;
    }

    public void appendRem(Integer keyTag) {
        if (this.remKeyTag == null) {
            this.remKeyTag = new ArrayList();
        }
        if (keyTag == null) {
            this.remKeyTag.add(new Integer(-1));
        } else {
            this.remKeyTag.add(keyTag);
        }
    }

    public void appendRem(int keyTag) {
        this.appendRem(new Integer(keyTag));
    }

    public void appendRem(EPPSecDNSExtDsData dsData) {
        int keyTag = -1;
        if (dsData != null) {
            keyTag = dsData.getKeyTag();
        }
        this.appendRem(new Integer(keyTag));
    }

    public boolean isUrgent() {
        return this.urgent;
    }

    public void setUrgent(boolean urgent) {
        this.urgent = urgent;
    }
}

