/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.resellerext;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.resellerext.EPPResellerExtCreate;
import com.verisign.epp.codec.resellerext.EPPResellerExtInfData;
import com.verisign.epp.codec.resellerext.EPPResellerExtUpdate;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPResellerExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPResellerExtTst(String name) {
        super(name);
    }

    public void testResellerExtCreate() {
        EPPCodecTst.printStart("testResellerExtCreate");
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("123456", "reseller.example", new EPPAuthInfo("2fooBAR"));
        theDomainCommand.addExtension(new EPPResellerExtCreate("myreseller"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testResellerExtCreate");
    }

    public void testResellerExtInfData() {
        EPPCodecTst.printStart("testResellerExtInfData");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPTransId respTransId = new EPPTransId("ngcl-IvJjzMZc", "test142AWQONJZ");
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-REP", "reseller.example", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        theResponse.addExtension(new EPPResellerExtInfData("myreseller"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-REP", "reseller.example", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        theResponse.addExtension(new EPPResellerExtInfData("myreseller", "example"));
        theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testResellerExtInfData");
    }

    public void testResellerExtUpdate() {
        EPPCodecTst.printStart("testResellerExtUpdate");
        EPPDomainUpdateCmd theDomainCommand = new EPPDomainUpdateCmd("123456", "reseller1.example", null, null, null);
        theDomainCommand.addExtension(new EPPResellerExtUpdate(EPPResellerExtUpdate.Action.ADD, "myreseller"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        theDomainCommand = new EPPDomainUpdateCmd("123456", "reseller2.example", null, null, null);
        theDomainCommand.addExtension(new EPPResellerExtUpdate(EPPResellerExtUpdate.Action.REM, "myreseller"));
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        theDomainCommand = new EPPDomainUpdateCmd("123456", "reseller3.example", null, null, null);
        theDomainCommand.addExtension(new EPPResellerExtUpdate(EPPResellerExtUpdate.Action.CHG, "myreseller"));
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testResellerExtUpdate");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPResellerExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.resellerext.EPPResellerExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPResellerExtTst Thread " + i, EPPResellerExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPResellerExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

