/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.reseller;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.reseller.EPPResellerContact;
import com.verisign.epp.codec.reseller.EPPResellerDisclose;
import com.verisign.epp.codec.reseller.EPPResellerPostalDefinition;
import com.verisign.epp.codec.reseller.State;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPResellerUpdateCmd
extends EPPUpdateCmd {
    private static Logger cat = Logger.getLogger((String)EPPResellerUpdateCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "update";
    public static final String ELM_NAME = "reseller:update";
    private static final String ELM_ADD = "add";
    private static final String ELM_REM = "rem";
    private static final String ELM_CHG = "chg";
    private static final String ELM_RESELLER_ID = "id";
    private static final String ELM_STATE = "state";
    private static final String ELM_PARENT_ID = "parentId";
    private static final String ELM_VOICE = "voice";
    private static final String ELM_FAX = "fax";
    private static final String ELM_EMAIL = "email";
    private static final String ELM_URL = "url";
    private static final String ATTR_EXT = "x";
    private String resellerId;
    private State state;
    private String parentId;
    private List<EPPResellerPostalDefinition> postalInfo = new ArrayList<EPPResellerPostalDefinition>();
    private String voice;
    private String voiceExt;
    private String fax;
    private String faxExt;
    private String email;
    private String url;
    private List<EPPResellerContact> addContacts = new ArrayList<EPPResellerContact>();
    private List<EPPResellerContact> remContacts = new ArrayList<EPPResellerContact>();
    private EPPResellerDisclose disclose;

    public EPPResellerUpdateCmd() {
    }

    public EPPResellerUpdateCmd(String aTransId) {
        super(aTransId);
    }

    public String getResellerId() {
        return this.resellerId;
    }

    public void setResellerId(String aResellerId) {
        this.resellerId = aResellerId;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State aState) {
        this.state = aState;
    }

    public boolean hasParentId() {
        return this.parentId != null;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPResellerPostalDefinition aPostalInfo) {
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPResellerPostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPResellerPostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo;
    }

    public boolean hasVoice() {
        return this.voice != null;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public boolean hasVoiceExt() {
        return this.voiceExt != null;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public boolean hasFax() {
        return this.fax != null;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public boolean hasFaxExt() {
        return this.faxExt != null;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public boolean hasEmail() {
        return this.email != null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public boolean hasAddContacts() {
        return this.addContacts != null && !this.addContacts.isEmpty();
    }

    public void addAddContact(EPPResellerContact aContact) {
        this.addContacts.add(aContact);
    }

    public List<EPPResellerContact> getAddContacts() {
        return this.addContacts;
    }

    public void setAddContacts(List<EPPResellerContact> aContacts) {
        this.addContacts = aContacts;
    }

    public boolean hasRemContacts() {
        return this.remContacts != null && !this.remContacts.isEmpty();
    }

    public void addRemContact(EPPResellerContact aContact) {
        this.remContacts.add(aContact);
    }

    public List<EPPResellerContact> getRemContacts() {
        return this.remContacts;
    }

    public void setRemContacts(List<EPPResellerContact> aContacts) {
        this.remContacts = aContacts;
    }

    public boolean hasDisclose() {
        return this.disclose != null;
    }

    public EPPResellerDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPResellerDisclose aDisclose) {
        this.disclose = aDisclose;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Text theVal = null;
        if (this.resellerId == null) {
            throw new EPPEncodeException("Undefined resellerId in EPPResellerUpdateCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.resellerId, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:id");
        if (this.hasAddContacts()) {
            Element addElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:add");
            EPPUtil.encodeCompList(aDocument, addElm, this.addContacts);
            root.appendChild(addElm);
        }
        if (this.hasRemContacts()) {
            Element remElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:rem");
            EPPUtil.encodeCompList(aDocument, remElm, this.remContacts);
            root.appendChild(remElm);
        }
        if (this.hasState() || this.hasParentId() || this.hasPostalInfo() || this.hasVoice() || this.hasFax() || this.hasEmail() || this.hasUrl() || this.hasDisclose()) {
            Element chgElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:chg");
            EPPUtil.encodeString(aDocument, chgElm, this.state.toString(), "urn:ietf:params:xml:ns:reseller-1.0", "reseller:state");
            EPPUtil.encodeString(aDocument, chgElm, this.parentId, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:parentId");
            EPPUtil.encodeCompList(aDocument, chgElm, this.postalInfo);
            if (this.voice != null) {
                theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:voice");
                theVal = aDocument.createTextNode(this.voice);
                theElm.appendChild(theVal);
                if (this.voiceExt != null) {
                    theElm.setAttribute(ATTR_EXT, this.voiceExt);
                }
                chgElm.appendChild(theElm);
            }
            if (this.fax != null) {
                theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:fax");
                theVal = aDocument.createTextNode(this.fax);
                theElm.appendChild(theVal);
                if (this.faxExt != null) {
                    theElm.setAttribute(ATTR_EXT, this.faxExt);
                }
                chgElm.appendChild(theElm);
            }
            EPPUtil.encodeString(aDocument, chgElm, this.email, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:email");
            EPPUtil.encodeString(aDocument, chgElm, this.url, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:url");
            EPPUtil.encodeComp(aDocument, chgElm, this.disclose);
            root.appendChild(chgElm);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theChgElm;
        Element theRemElm;
        Element theElm = null;
        this.resellerId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_ID);
        Element theAddElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_ADD);
        if (theAddElm != null) {
            this.addContacts = EPPUtil.decodeCompList(theAddElm, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:contact", EPPResellerContact.class);
        }
        if ((theRemElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_REM)) != null) {
            this.remContacts = EPPUtil.decodeCompList(theRemElm, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:contact", EPPResellerContact.class);
        }
        if ((theChgElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_CHG)) != null) {
            this.state = State.getState(EPPUtil.decodeString(theChgElm, "urn:ietf:params:xml:ns:reseller-1.0", ELM_STATE));
            this.parentId = EPPUtil.decodeString(theChgElm, "urn:ietf:params:xml:ns:reseller-1.0", ELM_PARENT_ID);
            this.postalInfo = EPPUtil.decodeCompList(theChgElm, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:postalInfo", EPPResellerPostalDefinition.class);
            theElm = EPPUtil.getElementByTagNameNS(theChgElm, "urn:ietf:params:xml:ns:reseller-1.0", ELM_VOICE);
            if (theElm != null) {
                this.voice = EPPUtil.getTextContent(theElm);
                this.voiceExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
            } else {
                this.voice = null;
                this.voiceExt = null;
            }
            theElm = EPPUtil.getElementByTagNameNS(theChgElm, "urn:ietf:params:xml:ns:reseller-1.0", ELM_FAX);
            if (theElm != null) {
                this.fax = EPPUtil.getTextContent(theElm);
                this.faxExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
            } else {
                this.fax = null;
                this.faxExt = null;
            }
            this.email = EPPUtil.decodeString(theChgElm, "urn:ietf:params:xml:ns:reseller-1.0", ELM_EMAIL);
            this.url = EPPUtil.decodeString(theChgElm, "urn:ietf:params:xml:ns:reseller-1.0", ELM_URL);
            this.disclose = (EPPResellerDisclose)EPPUtil.decodeComp(theChgElm, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:disclose", EPPResellerDisclose.class);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerUpdateCmd clone = (EPPResellerUpdateCmd)super.clone();
        if (this.hasPostalInfo()) {
            clone.postalInfo = (List)((ArrayList)this.postalInfo).clone();
        }
        if (this.hasAddContacts()) {
            clone.addContacts = (List)((ArrayList)this.addContacts).clone();
        }
        if (this.hasRemContacts()) {
            clone.remContacts = (List)((ArrayList)this.remContacts).clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:reseller-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerUpdateCmd)) {
            return false;
        }
        EPPResellerUpdateCmd other = (EPPResellerUpdateCmd)aObject;
        if (!EqualityUtil.equals(this.resellerId, other.resellerId)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): resellerId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.state, other.state)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): state not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): parentId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): parentId not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.postalInfo, other.postalInfo)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, other.fax)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, other.faxExt)) {
            cat.error((Object)("EPPResellerUpdateCmd.equals(): faxExt not equal, this.faxExt = " + this.faxExt + ", other.faxExt = " + other.faxExt));
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, other.url)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): url not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.addContacts, other.addContacts)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): addContacts not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.remContacts, other.remContacts)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): remContacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.disclose, other.disclose)) {
            cat.error((Object)"EPPResellerUpdateCmd.equals(): disclose not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

