/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.reseller;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.reseller.EPPResellerAddress;
import com.verisign.epp.codec.reseller.EPPResellerCheckCmd;
import com.verisign.epp.codec.reseller.EPPResellerCheckResp;
import com.verisign.epp.codec.reseller.EPPResellerCheckResult;
import com.verisign.epp.codec.reseller.EPPResellerContact;
import com.verisign.epp.codec.reseller.EPPResellerCreateCmd;
import com.verisign.epp.codec.reseller.EPPResellerCreateResp;
import com.verisign.epp.codec.reseller.EPPResellerDeleteCmd;
import com.verisign.epp.codec.reseller.EPPResellerDisclose;
import com.verisign.epp.codec.reseller.EPPResellerInfoCmd;
import com.verisign.epp.codec.reseller.EPPResellerInfoResp;
import com.verisign.epp.codec.reseller.EPPResellerPostalDefinition;
import com.verisign.epp.codec.reseller.EPPResellerUpdateCmd;
import com.verisign.epp.codec.reseller.State;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPResellerTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPResellerTst(String name) {
        super(name);
    }

    public void testCheckCommand() {
        EPPCodecTst.printStart("testCheckCommand");
        EPPResellerCheckCmd theCommand = new EPPResellerCheckCmd("ABC-12345", "res1523");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPResellerCheckCmd("ABC-12345");
        theCommand.addResellerId("res1523");
        theCommand.addResellerId("re1523");
        theCommand.addResellerId("1523res");
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckCommand");
    }

    public void testCheckResponse() {
        EPPCodecTst.printStart("testCheckResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPResellerCheckResp theResp = new EPPResellerCheckResp(theTransId, new EPPResellerCheckResult("res1523", true));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPResellerCheckResp(theTransId);
        theResp.addCheckResult(new EPPResellerCheckResult("res1523", true));
        theResp.addCheckResult(new EPPResellerCheckResult("re1523", "In use"));
        theResp.addCheckResult(new EPPResellerCheckResult("1523res", true));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckResponse");
    }

    public void testInfoCommand() {
        EPPCodecTst.printStart("testInfoCommand");
        EPPResellerInfoCmd theCommand = new EPPResellerInfoCmd("ABC-12345", "res1523");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoCommand");
    }

    public void testInfoResponse() {
        EPPCodecTst.printStart("testInfoResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPResellerInfoResp theResp = new EPPResellerInfoResp(theTransId, "res1523");
        theResp.setRoid("res1523-REP");
        theResp.setState(State.OK);
        theResp.setParentId("1523res");
        EPPResellerAddress theAddress = new EPPResellerAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        theResp.addPostalInfo(new EPPResellerPostalDefinition(EPPResellerPostalDefinition.Type.INT, "Example Reseller Inc.", theAddress));
        theResp.setVoice("+1.7035555555");
        theResp.setVoiceExt("1234");
        theResp.setFax("+1.7035555556");
        theResp.setEmail("contact@reseller.example");
        theResp.setUrl("http://reseller.example");
        theResp.addContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.ADMINISTRATIVE));
        theResp.addContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.BILLING));
        theResp.setClientId("ClientY");
        theResp.setCreatedBy("ClientX");
        theResp.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResp.setLastUpdatedBy("ClientX");
        theResp.setLastUpdatedDate(new GregorianCalendar(1999, 12, 3, 0, 0).getTime());
        EPPResellerDisclose disclose = new EPPResellerDisclose(false);
        disclose.setVoice(true);
        disclose.setEmail(true);
        theResp.setDisclose(disclose);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoResponse");
    }

    public void testCreateCommand() {
        EPPCodecTst.printStart("testCreateCommand");
        EPPResellerCreateCmd theCommand = new EPPResellerCreateCmd();
        theCommand.setResellerId("res1523");
        theCommand.setState(State.OK);
        theCommand.setParentId("1523res");
        EPPResellerAddress theAddress = new EPPResellerAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        theCommand.addPostalInfo(new EPPResellerPostalDefinition(EPPResellerPostalDefinition.Type.INT, "Example Reseller Inc.", theAddress));
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("1234");
        theCommand.setFax("+1.7035555556");
        theCommand.setEmail("contact@reseller.example");
        theCommand.setUrl("http://reseller.example");
        theCommand.addContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.ADMINISTRATIVE));
        theCommand.addContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.BILLING));
        EPPResellerDisclose disclose = new EPPResellerDisclose(false);
        disclose.setVoice(true);
        disclose.setEmail(true);
        theCommand.setDisclose(disclose);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCreateCommand");
    }

    public void testCreateResponse() {
        EPPCodecTst.printStart("testCreateResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPResellerCreateResp theResp = new EPPResellerCreateResp(theTransId, "res1523", new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCreateResponse");
    }

    public void testDeleteCommand() {
        EPPCodecTst.printStart("testDeleteCommand");
        EPPResellerDeleteCmd theCommand = new EPPResellerDeleteCmd("ABC-12345", "res1523");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testDeleteCommand");
    }

    public void testUpdateCommand() {
        EPPCodecTst.printStart("testUpdateCommand");
        EPPResellerUpdateCmd theCommand = new EPPResellerUpdateCmd();
        theCommand.setResellerId("res1523");
        theCommand.setState(State.OK);
        theCommand.setParentId("1523res");
        EPPResellerAddress theAddress = new EPPResellerAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        theCommand.addPostalInfo(new EPPResellerPostalDefinition(EPPResellerPostalDefinition.Type.INT, "Example Reseller Inc.", theAddress));
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("1234");
        theCommand.setFax("+1.7035555556");
        theCommand.setEmail("contact@reseller.example");
        theCommand.setUrl("http://reseller.example");
        theCommand.addAddContact(new EPPResellerContact("sh8014", EPPResellerContact.Type.ADMINISTRATIVE));
        theCommand.addRemContact(new EPPResellerContact("sh8013", EPPResellerContact.Type.BILLING));
        EPPResellerDisclose disclose = new EPPResellerDisclose(false);
        disclose.setVoice(true);
        disclose.setEmail(true);
        theCommand.setDisclose(disclose);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testUpdateCommand");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPResellerTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.contact.EPPContactMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.reseller.EPPResellerMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPResellerTst Thread " + i, EPPResellerTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPResellerTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

