/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.reseller;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.reseller.EPPResellerContact;
import com.verisign.epp.codec.reseller.EPPResellerDisclose;
import com.verisign.epp.codec.reseller.EPPResellerPostalDefinition;
import com.verisign.epp.codec.reseller.State;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPResellerInfoResp
extends EPPResponse {
    private static Logger cat = Logger.getLogger((String)EPPResellerInfoResp.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "reseller:infData";
    private static final String ELM_RESELLER_ID = "id";
    private static final String ELM_ROID = "roid";
    private static final String ELM_STATE = "state";
    private static final String ELM_PARENT_ID = "parentId";
    private static final String ELM_POSTAL_INFO = "postalInfo";
    private static final String ELM_VOICE = "voice";
    private static final String ELM_FAX = "fax";
    private static final String ELM_EMAIL = "email";
    private static final String ELM_URL = "url";
    private static final String ELM_CLIENT_ID = "clID";
    private static final String ELM_CREATED_BY = "crID";
    private static final String ELM_CREATED_DATE = "crDate";
    private static final String ELM_LAST_UPDATED_BY = "upID";
    private static final String ELM_LAST_UPDATED_DATE = "upDate";
    private static final String ELM_DISCLOSE = "disclose";
    private static final String ATTR_EXT = "x";
    private String resellerId;
    private String roid;
    private State state = State.OK;
    private String parentId;
    private List<EPPResellerPostalDefinition> postalInfo = new ArrayList<EPPResellerPostalDefinition>();
    private String voice;
    private String voiceExt;
    private String fax;
    private String faxExt;
    private String email;
    private String url;
    private List<EPPResellerContact> contacts = new ArrayList<EPPResellerContact>();
    private String clientId;
    private String createdBy;
    private Date createdDate;
    private String lastUpdatedBy;
    private Date lastUpdatedDate;
    private EPPResellerDisclose disclose;

    public EPPResellerInfoResp() {
    }

    public EPPResellerInfoResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPResellerInfoResp(EPPTransId aTransId, String aResellerId) {
        super(aTransId);
        this.resellerId = aResellerId;
    }

    public String getResellerId() {
        return this.resellerId;
    }

    public void setResellerId(String aResellerId) {
        this.resellerId = aResellerId;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State aState) {
        this.state = aState;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPResellerPostalDefinition aPostalInfo) {
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPResellerPostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPResellerPostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public void addContact(EPPResellerContact aContact) {
        this.contacts.add(aContact);
    }

    public List<EPPResellerContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPResellerContact> aContacts) {
        this.contacts = aContacts;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String aCreatedBy) {
        this.createdBy = aCreatedBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aCreatedDate) {
        this.createdDate = aCreatedDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String aLastUpdatedBy) {
        this.lastUpdatedBy = aLastUpdatedBy;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    public EPPResellerDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPResellerDisclose aDisclose) {
        this.disclose = aDisclose;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Text theVal = null;
        if (this.resellerId == null) {
            throw new EPPEncodeException("Undefined resellerId in EPPResellerInfoResp");
        }
        if (!this.hasPostalInfo()) {
            throw new EPPEncodeException("Undefined postal information in EPPResellerInfoResp");
        }
        if (this.email == null) {
            throw new EPPEncodeException("Undefined email in EPPResellerInfoResp");
        }
        if (this.clientId == null) {
            throw new EPPEncodeException("Undefined clientId in EPPResellerInfoResp");
        }
        if (this.createdBy == null) {
            throw new EPPEncodeException("Undefined createdBy in EPPResellerInfoResp");
        }
        if (this.createdDate == null) {
            throw new EPPEncodeException("Undefined createdDate in EPPResellerInfoResp");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.resellerId, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:id");
        EPPUtil.encodeString(aDocument, root, this.roid, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:roid");
        EPPUtil.encodeString(aDocument, root, this.state.toString(), "urn:ietf:params:xml:ns:reseller-1.0", "reseller:state");
        EPPUtil.encodeString(aDocument, root, this.parentId, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:parentId");
        EPPUtil.encodeCompList(aDocument, root, this.postalInfo);
        if (this.voice != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:voice");
            theVal = aDocument.createTextNode(this.voice);
            theElm.appendChild(theVal);
            if (this.voiceExt != null) {
                theElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            root.appendChild(theElm);
        }
        if (this.fax != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:fax");
            theVal = aDocument.createTextNode(this.fax);
            theElm.appendChild(theVal);
            if (this.faxExt != null) {
                theElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            root.appendChild(theElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:email");
        EPPUtil.encodeString(aDocument, root, this.url, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:url");
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:clID");
        EPPUtil.encodeString(aDocument, root, this.createdBy, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:crID");
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:crDate");
        EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:upID");
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:upDate");
        EPPUtil.encodeComp(aDocument, root, this.disclose);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theElm = null;
        this.resellerId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_ID);
        this.roid = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_ROID);
        this.state = State.getState(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_STATE));
        this.parentId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_PARENT_ID);
        this.postalInfo = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:postalInfo", EPPResellerPostalDefinition.class);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_VOICE);
        if (theElm != null) {
            this.voice = EPPUtil.getTextContent(theElm);
            this.voiceExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.voice = null;
            this.voiceExt = null;
        }
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_FAX);
        if (theElm != null) {
            this.fax = EPPUtil.getTextContent(theElm);
            this.faxExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.fax = null;
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_EMAIL);
        this.url = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_URL);
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:contact", EPPResellerContact.class);
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_CLIENT_ID);
        this.createdBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_CREATED_BY);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_CREATED_DATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_LAST_UPDATED_BY);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_LAST_UPDATED_DATE);
        this.disclose = (EPPResellerDisclose)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:disclose", EPPResellerDisclose.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerInfoResp clone = (EPPResellerInfoResp)super.clone();
        if (this.hasPostalInfo()) {
            clone.postalInfo = (List)((ArrayList)this.postalInfo).clone();
        }
        if (this.hasContacts()) {
            clone.contacts = (List)((ArrayList)this.contacts).clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:reseller-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerInfoResp)) {
            return false;
        }
        EPPResellerInfoResp other = (EPPResellerInfoResp)aObject;
        if (!EqualityUtil.equals(this.resellerId, other.resellerId)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): resellerId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.roid, other.roid)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): roid not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.state, other.state)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): state not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): parentId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): parentId not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.postalInfo, other.postalInfo)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, other.fax)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, other.faxExt)) {
            cat.error((Object)("EPPResellerInfoResp.equals(): faxExt not equal, this.faxExt = " + this.faxExt + ", other.faxExt = " + other.faxExt));
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, other.url)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): url not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.contacts, other.contacts)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.clientId, other.clientId)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): clientId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdBy, other.createdBy)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): createdBy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, other.createdDate)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): createdDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedBy, other.lastUpdatedBy)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): lastUpdatedBy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedDate, other.lastUpdatedDate)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): lastUpdateDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.disclose, other.disclose)) {
            cat.error((Object)"EPPResellerInfoResp.equals(): disclose not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

