/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.reseller;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPResellerDisclose
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPResellerDisclose.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "disclose";
    public static final String ELM_NAME = "reseller:disclose";
    private static final String ELM_RESELLER_NAME = "name";
    private static final String ELM_RESELLER_ORG = "org";
    private static final String ELM_RESELLER_ADDRESS = "address";
    private static final String ELM_RESELLER_VOICE = "voice";
    private static final String ELM_RESELLER_FAX = "fax";
    private static final String ELM_RESELLER_EMAIL = "email";
    private static final String ELM_RESELLER_URL = "url";
    private static final String ELM_RESELLER_CONTACT = "contact";
    private static final String ATTR_FLAG = "flag";
    private static final String ATTR_TYPE = "type";
    private static final int MAX_NAMES = 2;
    private static final int MAX_ORGS = 2;
    private static final int MAX_ADDRS = 2;
    private boolean flag = false;
    private List<Type> names = new ArrayList<Type>();
    private List<Type> orgs = new ArrayList<Type>();
    private List<Type> addresses = new ArrayList<Type>();
    private boolean voice = false;
    private boolean fax = false;
    private boolean email = false;
    private boolean url = false;
    private boolean contact = false;

    public EPPResellerDisclose() {
    }

    public EPPResellerDisclose(boolean aFlag) {
        this.flag = aFlag;
    }

    public boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    public void addName(Type aType) {
        this.names.add(aType);
    }

    public List<Type> getNames() {
        return this.names;
    }

    public void setNames(List<Type> aNames) {
        this.names = aNames == null ? new ArrayList<Type>() : aNames;
    }

    public boolean hasOrgs() {
        return this.orgs != null && !this.orgs.isEmpty();
    }

    public void addOrg(Type aType) {
        this.orgs.add(aType);
    }

    public List<Type> getOrgs() {
        return this.orgs;
    }

    public void setOrgs(List<Type> aOrgs) {
        this.orgs = aOrgs == null ? new ArrayList<Type>() : aOrgs;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public void addAddress(Type aType) {
        this.addresses.add(aType);
    }

    public List<Type> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Type> aAddresses) {
        this.addresses = aAddresses == null ? new ArrayList<Type>() : aAddresses;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean aFlag) {
        this.flag = aFlag;
    }

    public boolean isVoice() {
        return this.voice;
    }

    public void setVoice(boolean aVoice) {
        this.voice = aVoice;
    }

    public boolean isFax() {
        return this.fax;
    }

    public void setFax(boolean aFax) {
        this.fax = aFax;
    }

    public boolean isEmail() {
        return this.email;
    }

    public void setEmail(boolean aEmail) {
        this.email = aEmail;
    }

    public boolean isUrl() {
        return this.url;
    }

    public void setUrl(boolean aUrl) {
        this.url = aUrl;
    }

    public boolean isContact() {
        return this.contact;
    }

    public void setContact(boolean aContact) {
        this.contact = aContact;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        this.validateState();
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", ELM_NAME);
        EPPUtil.encodeBooleanAttr(root, ATTR_FLAG, this.flag);
        if (this.hasNames()) {
            for (Type theName : this.names) {
                theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:name");
                theElm.setAttribute(ATTR_TYPE, theName.toString());
            }
        }
        if (this.hasOrgs()) {
            for (Type theOrg : this.orgs) {
                theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:org");
                theElm.setAttribute(ATTR_TYPE, theOrg.toString());
            }
        }
        if (this.hasAddresses()) {
            for (Type theAddress : this.addresses) {
                theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:address");
                theElm.setAttribute(ATTR_TYPE, theAddress.toString());
            }
        }
        if (this.voice) {
            root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:voice"));
        }
        if (this.fax) {
            root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:fax"));
        }
        if (this.email) {
            root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:email"));
        }
        if (this.url) {
            root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:url"));
        }
        if (this.contact) {
            root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:contact"));
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        int i;
        Vector theChildren = null;
        this.flag = EPPUtil.decodeBooleanAttr(aElement, ATTR_FLAG);
        this.names = new ArrayList<Type>();
        theChildren = EPPUtil.getElementsByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_NAME);
        for (i = 0; i < theChildren.size(); ++i) {
            this.names.add(Type.getType(((Element)theChildren.elementAt(i)).getAttribute(ATTR_TYPE)));
        }
        this.orgs = new ArrayList<Type>();
        theChildren = EPPUtil.getElementsByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_ORG);
        for (i = 0; i < theChildren.size(); ++i) {
            this.orgs.add(Type.getType(((Element)theChildren.elementAt(i)).getAttribute(ATTR_TYPE)));
        }
        this.addresses = new ArrayList<Type>();
        theChildren = EPPUtil.getElementsByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_ADDRESS);
        for (i = 0; i < theChildren.size(); ++i) {
            this.addresses.add(Type.getType(((Element)theChildren.elementAt(i)).getAttribute(ATTR_TYPE)));
        }
        this.voice = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_VOICE) != null;
        this.fax = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_FAX) != null;
        this.email = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_EMAIL) != null;
        this.url = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_URL) != null;
        this.contact = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_CONTACT) != null;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerDisclose)) {
            return false;
        }
        EPPResellerDisclose theComp = (EPPResellerDisclose)aObject;
        if (!EqualityUtil.equals(this.flag, theComp.flag)) {
            cat.error((Object)"EPPResellerDisclose.equals(): flag not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.names, theComp.names)) {
            cat.error((Object)"EPPResellerDisclose.equals(): names not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.orgs, theComp.orgs)) {
            cat.error((Object)"EPPResellerDisclose.equals(): orgs not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.addresses, theComp.addresses)) {
            cat.error((Object)"EPPResellerDisclose.equals(): addresses not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, theComp.voice)) {
            cat.error((Object)"EPPResellerDisclose.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, theComp.fax)) {
            cat.error((Object)"EPPResellerDisclose.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.email, theComp.email)) {
            cat.error((Object)"EPPResellerDisclose.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, theComp.url)) {
            cat.error((Object)"EPPResellerDisclose.equals(): url not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contact, theComp.contact)) {
            cat.error((Object)"EPPResellerDisclose.equals(): contact not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerDisclose clone = (EPPResellerDisclose)super.clone();
        if (this.names != null) {
            clone.names = (List)((ArrayList)this.names).clone();
        }
        if (this.orgs != null) {
            clone.orgs = (List)((ArrayList)this.orgs).clone();
        }
        if (this.addresses != null) {
            clone.addresses = (List)((ArrayList)this.addresses).clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    protected void validateState() throws EPPEncodeException {
        if (this.names != null && !this.names.isEmpty() && this.names.size() > 2) {
            cat.error((Object)"EPPResellerDisclose.validateState(): name lines exceed the maximum of 2");
            throw new EPPEncodeException("name lines exceed the maximum of 2");
        }
        if (this.orgs != null && !this.orgs.isEmpty() && this.orgs.size() > 2) {
            cat.error((Object)"EPPResellerDisclose.validateState(): org lines exceed the maximum of 2");
            throw new EPPEncodeException("org lines exceed the maximum of 2");
        }
        if (this.addresses != null && !this.addresses.isEmpty() && this.addresses.size() > 2) {
            cat.error((Object)"EPPResellerDisclose.validateState(): address lines exceed the maximum of 2");
            throw new EPPEncodeException("address lines exceed the maximum of 2");
        }
    }

    public static enum Type implements Serializable,
    Cloneable
    {
        LOC("loc"),
        INT("int");

        private final String typeStr;

        private Type(String aTypeStr) {
            this.typeStr = aTypeStr;
        }

        public static Type getType(String aType) {
            if (aType.equals(Type.LOC.typeStr)) {
                return LOC;
            }
            if (aType.equals(Type.INT.typeStr)) {
                return INT;
            }
            throw new InvalidParameterException("Type enum value of " + aType + " is not valid.");
        }

        public String toString() {
            return this.typeStr;
        }
    }
}

