/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.reseller;

import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.reseller.EPPResellerContact;
import com.verisign.epp.codec.reseller.EPPResellerDisclose;
import com.verisign.epp.codec.reseller.EPPResellerPostalDefinition;
import com.verisign.epp.codec.reseller.State;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPResellerCreateCmd
extends EPPCreateCmd {
    private static Logger cat = Logger.getLogger((String)EPPResellerCreateCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "create";
    public static final String ELM_NAME = "reseller:create";
    private static final String ELM_RESELLER_ID = "id";
    private static final String ELM_STATE = "state";
    private static final String ELM_PARENT_ID = "parentId";
    private static final String ELM_VOICE = "voice";
    private static final String ELM_FAX = "fax";
    private static final String ELM_EMAIL = "email";
    private static final String ELM_URL = "url";
    private static final String ATTR_EXT = "x";
    private String resellerId;
    private State state = State.OK;
    private String parentId;
    private List<EPPResellerPostalDefinition> postalInfo = new ArrayList<EPPResellerPostalDefinition>();
    private String voice;
    private String voiceExt;
    private String fax;
    private String faxExt;
    private String email;
    private String url;
    private List<EPPResellerContact> contacts = new ArrayList<EPPResellerContact>();
    private EPPResellerDisclose disclose;

    public EPPResellerCreateCmd() {
    }

    public EPPResellerCreateCmd(String aTransId) {
        super(aTransId);
    }

    public String getResellerId() {
        return this.resellerId;
    }

    public void setResellerId(String aResellerId) {
        this.resellerId = aResellerId;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State aState) {
        this.state = aState == null ? State.OK : aState;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPResellerPostalDefinition aPostalInfo) {
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPResellerPostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPResellerPostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo == null ? new ArrayList<EPPResellerPostalDefinition>() : aPostalInfo;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public void addContact(EPPResellerContact aContact) {
        this.contacts.add(aContact);
    }

    public List<EPPResellerContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPResellerContact> aContacts) {
        this.contacts = aContacts == null ? new ArrayList<EPPResellerContact>() : aContacts;
    }

    public EPPResellerDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPResellerDisclose aDisclose) {
        this.disclose = aDisclose;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Text theVal = null;
        if (this.resellerId == null) {
            throw new EPPEncodeException("Undefined resellerId in EPPResellerCreateCmd");
        }
        if (!this.hasPostalInfo()) {
            throw new EPPEncodeException("Undefined postal information in EPPResellerCreateCmd");
        }
        if (this.email == null) {
            throw new EPPEncodeException("Undefined email in EPPResellerCreateCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.resellerId, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:id");
        EPPUtil.encodeString(aDocument, root, this.state.toString(), "urn:ietf:params:xml:ns:reseller-1.0", "reseller:state");
        EPPUtil.encodeString(aDocument, root, this.parentId, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:parentId");
        EPPUtil.encodeCompList(aDocument, root, this.postalInfo);
        if (this.voice != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:voice");
            theVal = aDocument.createTextNode(this.voice);
            theElm.appendChild(theVal);
            if (this.voiceExt != null) {
                theElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            root.appendChild(theElm);
        }
        if (this.fax != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:fax");
            theVal = aDocument.createTextNode(this.fax);
            theElm.appendChild(theVal);
            if (this.faxExt != null) {
                theElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            root.appendChild(theElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:email");
        EPPUtil.encodeString(aDocument, root, this.url, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:url");
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        EPPUtil.encodeComp(aDocument, root, this.disclose);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theElm = null;
        this.resellerId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_ID);
        this.state = State.getState(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_STATE));
        this.parentId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_PARENT_ID);
        this.postalInfo = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:postalInfo", EPPResellerPostalDefinition.class);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_VOICE);
        if (theElm != null) {
            this.voice = EPPUtil.getTextContent(theElm);
            this.voiceExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.voice = null;
            this.voiceExt = null;
        }
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_FAX);
        if (theElm != null) {
            this.fax = EPPUtil.getTextContent(theElm);
            this.faxExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.fax = null;
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_EMAIL);
        this.url = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_URL);
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:contact", EPPResellerContact.class);
        this.disclose = (EPPResellerDisclose)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:reseller-1.0", "reseller:disclose", EPPResellerDisclose.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerCreateCmd clone = (EPPResellerCreateCmd)super.clone();
        if (this.hasPostalInfo()) {
            clone.postalInfo = (List)((ArrayList)this.postalInfo).clone();
        }
        if (this.hasContacts()) {
            clone.contacts = (List)((ArrayList)this.contacts).clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:reseller-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerCreateCmd)) {
            return false;
        }
        EPPResellerCreateCmd other = (EPPResellerCreateCmd)aObject;
        if (!EqualityUtil.equals(this.resellerId, other.resellerId)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): resellerId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.state, other.state)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): state not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): parentId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): parentId not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.postalInfo, other.postalInfo)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, other.fax)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, other.faxExt)) {
            cat.error((Object)("EPPResellerCreateCmd.equals(): faxExt not equal, this.faxExt = " + this.faxExt + ", other.faxExt = " + other.faxExt));
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, other.url)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): url not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.contacts, other.contacts)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.disclose, other.disclose)) {
            cat.error((Object)"EPPResellerCreateCmd.equals(): disclose not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

