/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAuthInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAvailable;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreateResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDelete;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDeleteResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomainData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtField;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtFields;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtGroup;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtName;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtPeriod;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRegistered;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenew;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenewResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransferResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtUpdate;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.TestThread;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPRelatedDomainExtTst
extends TestCase {
    private static Logger cat = Logger.getLogger((String)EPPRelatedDomainExtTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static long numIterations = 1L;

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPRelatedDomainExtTst Thread " + i, EPPRelatedDomainExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPRelatedDomainExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPRelatedDomainExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPRelatedDomainExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public void testDomainInfoCmd() {
        EPPCodecTst.printStart("testDomainInfo");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd("ABC-12349", "xn--test.tld1");
        theCommand.setHosts("del");
        theCommand.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        theCommand.addExtension(new EPPRelatedDomainExtInfo(EPPRelatedDomainExtInfo.TYPE_DOMAIN));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "xn--test.tld1", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        this.encodeDecodeInfoResponse(theResponse);
        theCommand = new EPPDomainInfoCmd("ABC-12349", "xn--test.tld2");
        theCommand.setHosts("del");
        theCommand.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        theCommand.addExtension(new EPPRelatedDomainExtInfo(EPPRelatedDomainExtInfo.TYPE_RELATED));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        this.encodeDecodeInfoResponse(theResponse);
        EPPCodecTst.printEnd("testDomainInfo");
    }

    public void testDomainCreate() {
        EPPCodecTst.printStart("testDomainCreate");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> servers = new Vector<String>();
        servers.addElement("ns1.example.com");
        servers.addElement("ns2.example.com");
        Vector<EPPDomainContact> contacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "admin"));
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "tech"));
        }
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getFiveYearsFutureDate();
        theCommand = new EPPDomainCreateCmd("ABC-12345-XYZ", "example.com", servers, contacts, new EPPDomainPeriod(5), new EPPAuthInfo("2fooBAR"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo("2fooBAR"));
        Vector<EPPHostAttr> serverAttrs = new Vector<EPPHostAttr>();
        serverAttrs.add(new EPPHostAttr("ns1.example.com"));
        Vector<EPPHostAddress> hostAddresses = new Vector<EPPHostAddress>();
        hostAddresses.add(new EPPHostAddress("197.162.10.10"));
        serverAttrs.add(new EPPHostAttr("ns2.example.com", hostAddresses));
        theCommand.setServers(serverAttrs);
        EPPRelatedDomainExtCreate create = new EPPRelatedDomainExtCreate();
        EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
        EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(5);
        create.addDomain(new EPPRelatedDomainExtDomain("domain1.com", authInfo, period));
        create.addDomain(new EPPRelatedDomainExtDomain("domain2.com", authInfo, period));
        create.addDomain(new EPPRelatedDomainExtDomain("xn--idn.com", authInfo, period, "CHI"));
        theCommand.addExtension(create);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(respTransId, "example.com", theDate, expDate);
        theResponse.setResult(1000);
        EPPRelatedDomainExtCreateResp resp = new EPPRelatedDomainExtCreateResp();
        resp.addDomain(new EPPRelatedDomainExtDomainData("domain1.com", theDate, expDate));
        resp.addDomain(new EPPRelatedDomainExtDomainData("domain2.com", theDate, expDate));
        resp.addDomain(new EPPRelatedDomainExtDomainData("xn--idn.com", theDate, expDate));
        theResponse.addExtension(resp);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainCreate");
    }

    public void testDomainDelete() {
        EPPCodecTst.printStart("testDomainDelete");
        EPPDomainDeleteCmd theCommand = new EPPDomainDeleteCmd("ABC-12345", "example.com");
        EPPRelatedDomainExtDelete delete = new EPPRelatedDomainExtDelete();
        delete.addDomain("domain1.com");
        delete.addDomain("domain2.com");
        theCommand.addExtension(delete);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1001);
        EPPRelatedDomainExtDeleteResp resp = new EPPRelatedDomainExtDeleteResp();
        resp.addDomain(new EPPRelatedDomainExtDomainData("domain1.com", "deleted"));
        resp.addDomain(new EPPRelatedDomainExtDomainData("domain2.com", "pendingDelete"));
        resp.addDomain(new EPPRelatedDomainExtDomainData("xn--idn.com", "pendingDelete"));
        theResponse.addExtension(resp);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainDelete");
    }

    public void testDomainUpdate() {
        EPPCodecTst.printStart("testDomainUpdate");
        Vector<String> addServers = new Vector<String>();
        addServers.addElement("ns1.example.com");
        Vector<EPPDomainStatus> addStatuses = new Vector<EPPDomainStatus>();
        addStatuses.addElement(new EPPDomainStatus("clientHold", "The description"));
        Vector<EPPDomainContact> addContacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            addContacts = new Vector<EPPDomainContact>();
            addContacts.addElement(new EPPDomainContact("MAK21-VRSN", "tech"));
        }
        Vector<String> removeServers = new Vector<String>();
        removeServers.addElement("ns2.example.com");
        Vector<EPPDomainStatus> removeStatuses = new Vector<EPPDomainStatus>();
        removeStatuses.addElement(new EPPDomainStatus("clientHold"));
        Vector<EPPDomainContact> removeContacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            removeContacts = new Vector<EPPDomainContact>();
            removeContacts.addElement(new EPPDomainContact("SH8013-VRSN", "tech"));
        }
        EPPDomainAddRemove addItems = new EPPDomainAddRemove(addServers, addContacts, addStatuses);
        EPPDomainAddRemove removeItems = new EPPDomainAddRemove(removeServers, removeContacts, removeStatuses);
        EPPDomainAddRemove changeItems = new EPPDomainAddRemove("SH8013-VRSN", new EPPAuthInfo("2fooBAR"));
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345-XYZ", "example.com", addItems, removeItems, changeItems);
        EPPRelatedDomainExtUpdate update = new EPPRelatedDomainExtUpdate();
        update.addDomain("domain1.com");
        update.addDomain("domain2.com");
        theCommand.addExtension(update);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPDomainAddRemove emptyChangeItems = new EPPDomainAddRemove();
        Assert.assertTrue((boolean)emptyChangeItems.isEmpty());
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainUpdate");
    }

    public void testDomainRenew() {
        EPPCodecTst.printStart("testDomainRenew");
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getFiveYearsFutureDate();
        EPPDomainRenewCmd theCommand = new EPPDomainRenewCmd("ABC-12345", "example.com", theDate, new EPPDomainPeriod(5));
        EPPRelatedDomainExtRenew renew = new EPPRelatedDomainExtRenew();
        theCommand.addExtension(renew);
        EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
        EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(5);
        renew.addDomain(new EPPRelatedDomainExtDomain("domain1.com", theDate, period));
        renew.addDomain(new EPPRelatedDomainExtDomain("domain2.com", theDate, period));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(respTransId, "example.com", expDate);
        theResponse.setResult(1000);
        EPPRelatedDomainExtRenewResp resp = new EPPRelatedDomainExtRenewResp();
        resp.addDomain(new EPPRelatedDomainExtDomainData("domain1.com", expDate));
        resp.addDomain(new EPPRelatedDomainExtDomainData("domain2.com", expDate));
        theResponse.addExtension(resp);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainRenew");
    }

    public void testDomainTransfer() {
        EPPCodecTst.printStart("testDomainTransfer");
        EPPDomainTransferCmd theCommand = new EPPDomainTransferCmd("ABC-12345", "request", "example.com", new EPPAuthInfo("2fooBAR"), new EPPDomainPeriod(1));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPAuthInfo theAuthInfo = new EPPAuthInfo("2fooBAR");
        theAuthInfo.setRoid("JD1234-REP");
        theCommand = new EPPDomainTransferCmd("ABC-12345", "request", "example.com", theAuthInfo, new EPPDomainPeriod(1));
        EPPRelatedDomainExtTransfer transfer = new EPPRelatedDomainExtTransfer();
        EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
        EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(1);
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain1.com", authInfo, period));
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain2.com", authInfo));
        theCommand.addExtension(transfer);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPDomainTransferResp theResponse = this.getEPPDomainTransferResp("example.com", "request");
        EPPRelatedDomainExtTransferResp respExt = new EPPRelatedDomainExtTransferResp();
        respExt.addDomain(this.getDomainDataForTransferResp("domain1.com", "request"));
        respExt.addDomain(this.getDomainDataForTransferResp("domain2.com", "request"));
        theResponse.addExtension(respExt);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "cancel", "example.com");
        transfer = new EPPRelatedDomainExtTransfer();
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain1.com"));
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain2.com"));
        theCommand.addExtension(transfer);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = this.getEPPDomainTransferResp("example.com", "cancel");
        respExt = new EPPRelatedDomainExtTransferResp();
        respExt.addDomain(this.getDomainDataForTransferResp("domain1.com", "cancel"));
        respExt.addDomain(this.getDomainDataForTransferResp("domain2.com", "cancel"));
        theResponse.addExtension(respExt);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "query", "example.com");
        transfer = new EPPRelatedDomainExtTransfer();
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain1.com"));
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain2.com"));
        theCommand.addExtension(transfer);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = this.getEPPDomainTransferResp("example.com", "query");
        respExt = new EPPRelatedDomainExtTransferResp();
        respExt.addDomain(this.getDomainDataForTransferResp("domain1.com", "query"));
        respExt.addDomain(this.getDomainDataForTransferResp("domain2.com", "query"));
        theResponse.addExtension(respExt);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "reject", "example.com");
        transfer = new EPPRelatedDomainExtTransfer();
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain1.com"));
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain2.com"));
        theCommand.addExtension(transfer);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = this.getEPPDomainTransferResp("example.com", "reject");
        respExt = new EPPRelatedDomainExtTransferResp();
        respExt.addDomain(this.getDomainDataForTransferResp("domain1.com", "reject"));
        respExt.addDomain(this.getDomainDataForTransferResp("domain2.com", "reject"));
        theResponse.addExtension(respExt);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "approve", "example.com");
        transfer = new EPPRelatedDomainExtTransfer();
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain1.com"));
        transfer.addDomain(new EPPRelatedDomainExtDomain("domain2.com"));
        theCommand.addExtension(transfer);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = this.getEPPDomainTransferResp("example.com", "approve");
        respExt = new EPPRelatedDomainExtTransferResp();
        respExt.addDomain(this.getDomainDataForTransferResp("domain1.com", "approve"));
        respExt.addDomain(this.getDomainDataForTransferResp("domain2.com", "approve"));
        theResponse.addExtension(respExt);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainTransfer");
    }

    private EPPDomainTransferResp getEPPDomainTransferResp(String aDomainName, String aCommandType) {
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getOneYearFutureDate();
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(respTransId, aDomainName);
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus(this.getTransferStatus(aCommandType));
        theResponse.setRequestDate(theDate);
        theResponse.setActionDate(theDate);
        theResponse.setExpirationDate(expDate);
        return theResponse;
    }

    private EPPRelatedDomainExtDomainData getDomainDataForTransferResp(String aDomainName, String aCommandType) {
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getOneYearFutureDate();
        EPPRelatedDomainExtDomainData result = new EPPRelatedDomainExtDomainData();
        result.setName(aDomainName);
        result.setRequestClient("ClientX");
        result.setActionClient("ClientY");
        result.setTransferStatus(this.getTransferStatus(aCommandType));
        result.setRequestDate(theDate);
        result.setActionDate(theDate);
        result.setExpirationDate(expDate);
        return result;
    }

    private String getTransferStatus(String aCommandType) {
        if (aCommandType.equals("request") || aCommandType.equals("query")) {
            return "pending";
        }
        if (aCommandType.equals("cancel")) {
            return "clientCancelled";
        }
        if (aCommandType.equals("reject")) {
            return "clientRejected";
        }
        if (aCommandType.equals("approve")) {
            return "clientApproved";
        }
        return "pending";
    }

    private void encodeDecodeInfoResponse(EPPResponse aResponse) {
        EPPCodecTst.printStart("testDomainInfo");
        EPPRelatedDomainExtInfData infData = new EPPRelatedDomainExtInfData();
        EPPRelatedDomainExtFields fields = new EPPRelatedDomainExtFields();
        fields.setInSync(false);
        fields.addField(new EPPRelatedDomainExtField("registrar", false));
        fields.addField(new EPPRelatedDomainExtField("registrant", true));
        fields.addField(new EPPRelatedDomainExtField("ns", false));
        EPPRelatedDomainExtRegistered registered = new EPPRelatedDomainExtRegistered();
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test.tld1"));
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test.tld2"));
        infData.addGroup(new EPPRelatedDomainExtGroup("tld", fields, null, registered));
        fields = new EPPRelatedDomainExtFields();
        fields.setInSync(true);
        fields.addField(new EPPRelatedDomainExtField("registrar", true));
        fields.addField(new EPPRelatedDomainExtField("registrant", true));
        fields.addField(new EPPRelatedDomainExtField("ns", true));
        registered = new EPPRelatedDomainExtRegistered();
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test-variant1.tld1"));
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test-variant2.tld1"));
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test-variant3.tld1"));
        EPPRelatedDomainExtAvailable avail = new EPPRelatedDomainExtAvailable();
        avail.addAvailableDomain(new EPPRelatedDomainExtName("xn--test-variant4.tld1"));
        avail.addAvailableDomain(new EPPRelatedDomainExtName("xn--test-variant5.tld1"));
        avail.addAvailableDomain(new EPPRelatedDomainExtName("xn--test-variant6.tld1"));
        infData.addGroup(new EPPRelatedDomainExtGroup("variant", fields, avail, registered));
        aResponse.addExtension(infData);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(aResponse);
        System.out.println(responseStats);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private Date getTodaysUTCDateAtMidnight() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getFiveYearsFutureDate() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(1, 5);
        return cal.getTime();
    }

    private Date getOneYearFutureDate() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(1, 1);
        return cal.getTime();
    }
}

