/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResult;
import com.verisign.epp.codec.nv.EPPNameVerificationStatus;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPNameVerificationCreateSuccess
implements EPPNameVerificationCreateResult {
    private static Logger cat = Logger.getLogger((String)EPPNameVerificationCreateSuccess.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "success";
    public static final String ELM_NAME = "nv:success";
    private static final String ELM_CODE = "code";
    private static final String ATTR_TYPE = "type";
    private static final String ELM_STATUS = "status";
    private static final String ATTR_STATUS = "s";
    private static final String ELM_CREATION_DATE = "crDate";
    private static final String ELM_SIGNED_CODE = "encodedSignedCode";
    private String code;
    private String type;
    private EPPNameVerificationStatus status;
    private Date creationDate = null;
    private EPPEncodedSignedCodeValue signedCode;

    public EPPNameVerificationCreateSuccess() {
    }

    public EPPNameVerificationCreateSuccess(String aCode, String aType, EPPNameVerificationStatus aStatus, Date aCrDate, EPPEncodedSignedCodeValue aSignedCode) {
        this.code = aCode;
        this.type = aType;
        this.status = aStatus;
        this.creationDate = aCrDate;
        this.signedCode = aSignedCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public String getCodeType() {
        return this.type;
    }

    public void setCodeType(String aType) {
        this.type = aType;
    }

    public EPPNameVerificationStatus getStatus() {
        return this.status;
    }

    public void setStatus(EPPNameVerificationStatus aStatus) {
        this.status = aStatus;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date aCreationDate) {
        this.creationDate = aCreationDate;
    }

    public EPPEncodedSignedCodeValue getSignedCode() {
        return this.signedCode;
    }

    public void setSignedCode(EPPEncodedSignedCodeValue aSignedCode) {
        this.signedCode = aSignedCode;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.code == null) {
            throw new EPPEncodeException("Undefined code in EPPNameVerificationCreateSuccess");
        }
        if (this.type == null) {
            throw new EPPEncodeException("Undefined type in EPPNameVerificationCreateSuccess");
        }
        if (this.status == null) {
            throw new EPPEncodeException("Undefined status in EPPNameVerificationCreateSuccess");
        }
        if (this.creationDate == null) {
            throw new EPPEncodeException("Undefined creationDate in EPPNameVerificationCreateSuccess");
        }
        if (this.signedCode == null) {
            throw new EPPEncodeException("Undefined signedCode in EPPNameVerificationCreateSuccess");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        Element code = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:code");
        Text codeVal = aDocument.createTextNode(this.code);
        code.appendChild(codeVal);
        root.appendChild(code);
        code.setAttribute(ATTR_TYPE, this.type);
        Element theStatusElm = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:status");
        root.appendChild(theStatusElm);
        theStatusElm.setAttribute(ATTR_STATUS, this.status.toString());
        EPPUtil.encodeTimeInstant(aDocument, root, this.creationDate, "urn:ietf:params:xml:ns:nv-1.0", "nv:crDate");
        EPPUtil.encodeString(aDocument, root, this.signedCode.encodeValue(), "urn:ietf:params:xml:ns:nv-1.0", "nv:encodedSignedCode");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.code = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CODE);
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CODE);
        this.type = theElm.getAttribute(ATTR_TYPE);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_STATUS);
        String theStatusStr = theElm.getAttribute(ATTR_STATUS);
        this.status = EPPNameVerificationStatus.getStatus(theStatusStr);
        this.creationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CREATION_DATE);
        String encodedSignedCodeXML = "<verificationCode:code xmlns:verificationCode=\"urn:ietf:params:xml:ns:verificationCode-1.0\">" + EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_SIGNED_CODE) + "</verificationCode:code>";
        this.signedCode = new EPPEncodedSignedCodeValue(encodedSignedCodeXML.getBytes());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationCreateSuccess clone = (EPPNameVerificationCreateSuccess)super.clone();
        clone.code = this.code;
        clone.type = this.type;
        clone.status = this.status;
        clone.creationDate = this.creationDate;
        clone.signedCode = this.signedCode != null ? (EPPEncodedSignedCodeValue)this.signedCode.clone() : null;
        return clone;
    }

    public String getType() {
        return ELM_NAME;
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationCreateSuccess)) {
            return false;
        }
        EPPNameVerificationCreateSuccess other = (EPPNameVerificationCreateSuccess)aObject;
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error((Object)"EPPNameVerificationCreateSuccess.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error((Object)"EPPNameVerificationCreateSuccess.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.status, (Object)other.status)) {
            cat.error((Object)"EPPNameVerificationCreateSuccess.equals(): status not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.creationDate, other.creationDate)) {
            cat.error((Object)"EPPNameVerificationCreateSuccess.equals(): creationDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.signedCode, other.signedCode)) {
            cat.error((Object)"EPPNameVerificationCreateSuccess.equals(): signedCode not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

